/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ObservationLevel;
import com.langfuse.client.resources.ingestion.types.IOptionalObservationBody;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OptionalObservationBody
implements IOptionalObservationBody {
    private final Optional<String> traceId;
    private final Optional<String> name;
    private final Optional<OffsetDateTime> startTime;
    private final Optional<Object> metadata;
    private final Optional<Object> input;
    private final Optional<Object> output;
    private final Optional<ObservationLevel> level;
    private final Optional<String> statusMessage;
    private final Optional<String> parentObservationId;
    private final Optional<String> version;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private OptionalObservationBody(Optional<String> traceId, Optional<String> name, Optional<OffsetDateTime> startTime, Optional<Object> metadata, Optional<Object> input, Optional<Object> output, Optional<ObservationLevel> level, Optional<String> statusMessage, Optional<String> parentObservationId, Optional<String> version, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.traceId = traceId;
        this.name = name;
        this.startTime = startTime;
        this.metadata = metadata;
        this.input = input;
        this.output = output;
        this.level = level;
        this.statusMessage = statusMessage;
        this.parentObservationId = parentObservationId;
        this.version = version;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="startTime")
    public Optional<OffsetDateTime> getStartTime() {
        return this.startTime;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @Override
    @JsonProperty(value="output")
    public Optional<Object> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="level")
    public Optional<ObservationLevel> getLevel() {
        return this.level;
    }

    @Override
    @JsonProperty(value="statusMessage")
    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    @JsonProperty(value="parentObservationId")
    public Optional<String> getParentObservationId() {
        return this.parentObservationId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OptionalObservationBody && this.equalTo((OptionalObservationBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OptionalObservationBody other) {
        return this.traceId.equals(other.traceId) && this.name.equals(other.name) && this.startTime.equals(other.startTime) && this.metadata.equals(other.metadata) && this.input.equals(other.input) && this.output.equals(other.output) && this.level.equals(other.level) && this.statusMessage.equals(other.statusMessage) && this.parentObservationId.equals(other.parentObservationId) && this.version.equals(other.version) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.name, this.startTime, this.metadata, this.input, this.output, this.level, this.statusMessage, this.parentObservationId, this.version, this.environment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> traceId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<OffsetDateTime> startTime = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<Object> input = Optional.empty();
        private Optional<Object> output = Optional.empty();
        private Optional<ObservationLevel> level = Optional.empty();
        private Optional<String> statusMessage = Optional.empty();
        private Optional<String> parentObservationId = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> environment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OptionalObservationBody other) {
            this.traceId(other.getTraceId());
            this.name(other.getName());
            this.startTime(other.getStartTime());
            this.metadata(other.getMetadata());
            this.input(other.getInput());
            this.output(other.getOutput());
            this.level(other.getLevel());
            this.statusMessage(other.getStatusMessage());
            this.parentObservationId(other.getParentObservationId());
            this.version(other.getVersion());
            this.environment(other.getEnvironment());
            return this;
        }

        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public Builder traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="startTime", nulls=Nulls.SKIP)
        public Builder startTime(Optional<OffsetDateTime> startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = Optional.ofNullable(startTime);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public Builder input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        public Builder input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public Builder output(Optional<Object> output) {
            this.output = output;
            return this;
        }

        public Builder output(Object output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @JsonSetter(value="level", nulls=Nulls.SKIP)
        public Builder level(Optional<ObservationLevel> level) {
            this.level = level;
            return this;
        }

        public Builder level(ObservationLevel level) {
            this.level = Optional.ofNullable(level);
            return this;
        }

        @JsonSetter(value="statusMessage", nulls=Nulls.SKIP)
        public Builder statusMessage(Optional<String> statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = Optional.ofNullable(statusMessage);
            return this;
        }

        @JsonSetter(value="parentObservationId", nulls=Nulls.SKIP)
        public Builder parentObservationId(Optional<String> parentObservationId) {
            this.parentObservationId = parentObservationId;
            return this;
        }

        public Builder parentObservationId(String parentObservationId) {
            this.parentObservationId = Optional.ofNullable(parentObservationId);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        public OptionalObservationBody build() {
            return new OptionalObservationBody(this.traceId, this.name, this.startTime, this.metadata, this.input, this.output, this.level, this.statusMessage, this.parentObservationId, this.version, this.environment, this.additionalProperties);
        }
    }
}

