/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.datasetitems.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.DatasetStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDatasetItemRequest {
    private final String datasetName;
    private final Optional<Object> input;
    private final Optional<Object> expectedOutput;
    private final Optional<Object> metadata;
    private final Optional<String> sourceTraceId;
    private final Optional<String> sourceObservationId;
    private final Optional<String> id;
    private final Optional<DatasetStatus> status;
    private final Map<String, Object> additionalProperties;

    private CreateDatasetItemRequest(String datasetName, Optional<Object> input, Optional<Object> expectedOutput, Optional<Object> metadata, Optional<String> sourceTraceId, Optional<String> sourceObservationId, Optional<String> id, Optional<DatasetStatus> status, Map<String, Object> additionalProperties) {
        this.datasetName = datasetName;
        this.input = input;
        this.expectedOutput = expectedOutput;
        this.metadata = metadata;
        this.sourceTraceId = sourceTraceId;
        this.sourceObservationId = sourceObservationId;
        this.id = id;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="datasetName")
    public String getDatasetName() {
        return this.datasetName;
    }

    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @JsonProperty(value="expectedOutput")
    public Optional<Object> getExpectedOutput() {
        return this.expectedOutput;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="sourceTraceId")
    public Optional<String> getSourceTraceId() {
        return this.sourceTraceId;
    }

    @JsonProperty(value="sourceObservationId")
    public Optional<String> getSourceObservationId() {
        return this.sourceObservationId;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Optional<DatasetStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDatasetItemRequest && this.equalTo((CreateDatasetItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDatasetItemRequest other) {
        return this.datasetName.equals(other.datasetName) && this.input.equals(other.input) && this.expectedOutput.equals(other.expectedOutput) && this.metadata.equals(other.metadata) && this.sourceTraceId.equals(other.sourceTraceId) && this.sourceObservationId.equals(other.sourceObservationId) && this.id.equals(other.id) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.datasetName, this.input, this.expectedOutput, this.metadata, this.sourceTraceId, this.sourceObservationId, this.id, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DatasetNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DatasetNameStage,
    _FinalStage {
        private String datasetName;
        private Optional<DatasetStatus> status = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> sourceObservationId = Optional.empty();
        private Optional<String> sourceTraceId = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<Object> expectedOutput = Optional.empty();
        private Optional<Object> input = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDatasetItemRequest other) {
            this.datasetName(other.getDatasetName());
            this.input(other.getInput());
            this.expectedOutput(other.getExpectedOutput());
            this.metadata(other.getMetadata());
            this.sourceTraceId(other.getSourceTraceId());
            this.sourceObservationId(other.getSourceObservationId());
            this.id(other.getId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="datasetName")
        public _FinalStage datasetName(@NotNull String datasetName) {
            this.datasetName = Objects.requireNonNull(datasetName, "datasetName must not be null");
            return this;
        }

        @Override
        public _FinalStage status(DatasetStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<DatasetStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage sourceObservationId(String sourceObservationId) {
            this.sourceObservationId = Optional.ofNullable(sourceObservationId);
            return this;
        }

        @Override
        @JsonSetter(value="sourceObservationId", nulls=Nulls.SKIP)
        public _FinalStage sourceObservationId(Optional<String> sourceObservationId) {
            this.sourceObservationId = sourceObservationId;
            return this;
        }

        @Override
        public _FinalStage sourceTraceId(String sourceTraceId) {
            this.sourceTraceId = Optional.ofNullable(sourceTraceId);
            return this;
        }

        @Override
        @JsonSetter(value="sourceTraceId", nulls=Nulls.SKIP)
        public _FinalStage sourceTraceId(Optional<String> sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage expectedOutput(Object expectedOutput) {
            this.expectedOutput = Optional.ofNullable(expectedOutput);
            return this;
        }

        @Override
        @JsonSetter(value="expectedOutput", nulls=Nulls.SKIP)
        public _FinalStage expectedOutput(Optional<Object> expectedOutput) {
            this.expectedOutput = expectedOutput;
            return this;
        }

        @Override
        public _FinalStage input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        @Override
        public CreateDatasetItemRequest build() {
            return new CreateDatasetItemRequest(this.datasetName, this.input, this.expectedOutput, this.metadata, this.sourceTraceId, this.sourceObservationId, this.id, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDatasetItemRequest build();

        public _FinalStage input(Optional<Object> var1);

        public _FinalStage input(Object var1);

        public _FinalStage expectedOutput(Optional<Object> var1);

        public _FinalStage expectedOutput(Object var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage sourceTraceId(Optional<String> var1);

        public _FinalStage sourceTraceId(String var1);

        public _FinalStage sourceObservationId(Optional<String> var1);

        public _FinalStage sourceObservationId(String var1);

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage status(Optional<DatasetStatus> var1);

        public _FinalStage status(DatasetStatus var1);
    }

    public static interface DatasetNameStage {
        public _FinalStage datasetName(@NotNull String var1);

        public Builder from(CreateDatasetItemRequest var1);
    }
}

