/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ModelUsageUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Usage {
    private final Optional<Integer> input;
    private final Optional<Integer> output;
    private final Optional<Integer> total;
    private final Optional<ModelUsageUnit> unit;
    private final Optional<Double> inputCost;
    private final Optional<Double> outputCost;
    private final Optional<Double> totalCost;
    private final Map<String, Object> additionalProperties;

    private Usage(Optional<Integer> input, Optional<Integer> output, Optional<Integer> total, Optional<ModelUsageUnit> unit, Optional<Double> inputCost, Optional<Double> outputCost, Optional<Double> totalCost, Map<String, Object> additionalProperties) {
        this.input = input;
        this.output = output;
        this.total = total;
        this.unit = unit;
        this.inputCost = inputCost;
        this.outputCost = outputCost;
        this.totalCost = totalCost;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="input")
    public Optional<Integer> getInput() {
        return this.input;
    }

    @JsonProperty(value="output")
    public Optional<Integer> getOutput() {
        return this.output;
    }

    @JsonProperty(value="total")
    public Optional<Integer> getTotal() {
        return this.total;
    }

    @JsonProperty(value="unit")
    public Optional<ModelUsageUnit> getUnit() {
        return this.unit;
    }

    @JsonProperty(value="inputCost")
    public Optional<Double> getInputCost() {
        return this.inputCost;
    }

    @JsonProperty(value="outputCost")
    public Optional<Double> getOutputCost() {
        return this.outputCost;
    }

    @JsonProperty(value="totalCost")
    public Optional<Double> getTotalCost() {
        return this.totalCost;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Usage && this.equalTo((Usage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Usage other) {
        return this.input.equals(other.input) && this.output.equals(other.output) && this.total.equals(other.total) && this.unit.equals(other.unit) && this.inputCost.equals(other.inputCost) && this.outputCost.equals(other.outputCost) && this.totalCost.equals(other.totalCost);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.total, this.unit, this.inputCost, this.outputCost, this.totalCost);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> input = Optional.empty();
        private Optional<Integer> output = Optional.empty();
        private Optional<Integer> total = Optional.empty();
        private Optional<ModelUsageUnit> unit = Optional.empty();
        private Optional<Double> inputCost = Optional.empty();
        private Optional<Double> outputCost = Optional.empty();
        private Optional<Double> totalCost = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Usage other) {
            this.input(other.getInput());
            this.output(other.getOutput());
            this.total(other.getTotal());
            this.unit(other.getUnit());
            this.inputCost(other.getInputCost());
            this.outputCost(other.getOutputCost());
            this.totalCost(other.getTotalCost());
            return this;
        }

        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public Builder input(Optional<Integer> input) {
            this.input = input;
            return this;
        }

        public Builder input(Integer input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public Builder output(Optional<Integer> output) {
            this.output = output;
            return this;
        }

        public Builder output(Integer output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @JsonSetter(value="total", nulls=Nulls.SKIP)
        public Builder total(Optional<Integer> total) {
            this.total = total;
            return this;
        }

        public Builder total(Integer total) {
            this.total = Optional.ofNullable(total);
            return this;
        }

        @JsonSetter(value="unit", nulls=Nulls.SKIP)
        public Builder unit(Optional<ModelUsageUnit> unit) {
            this.unit = unit;
            return this;
        }

        public Builder unit(ModelUsageUnit unit) {
            this.unit = Optional.ofNullable(unit);
            return this;
        }

        @JsonSetter(value="inputCost", nulls=Nulls.SKIP)
        public Builder inputCost(Optional<Double> inputCost) {
            this.inputCost = inputCost;
            return this;
        }

        public Builder inputCost(Double inputCost) {
            this.inputCost = Optional.ofNullable(inputCost);
            return this;
        }

        @JsonSetter(value="outputCost", nulls=Nulls.SKIP)
        public Builder outputCost(Optional<Double> outputCost) {
            this.outputCost = outputCost;
            return this;
        }

        public Builder outputCost(Double outputCost) {
            this.outputCost = Optional.ofNullable(outputCost);
            return this;
        }

        @JsonSetter(value="totalCost", nulls=Nulls.SKIP)
        public Builder totalCost(Optional<Double> totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public Builder totalCost(Double totalCost) {
            this.totalCost = Optional.ofNullable(totalCost);
            return this;
        }

        public Usage build() {
            return new Usage(this.input, this.output, this.total, this.unit, this.inputCost, this.outputCost, this.totalCost, this.additionalProperties);
        }
    }
}

