/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ITrace;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Trace
implements ITrace {
    private final String id;
    private final OffsetDateTime timestamp;
    private final Optional<String> name;
    private final Optional<Object> input;
    private final Optional<Object> output;
    private final Optional<String> sessionId;
    private final Optional<String> release;
    private final Optional<String> version;
    private final Optional<String> userId;
    private final Optional<Object> metadata;
    private final Optional<List<String>> tags;
    private final Optional<Boolean> public_;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private Trace(String id, OffsetDateTime timestamp, Optional<String> name, Optional<Object> input, Optional<Object> output, Optional<String> sessionId, Optional<String> release, Optional<String> version, Optional<String> userId, Optional<Object> metadata, Optional<List<String>> tags, Optional<Boolean> public_, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.id = id;
        this.timestamp = timestamp;
        this.name = name;
        this.input = input;
        this.output = output;
        this.sessionId = sessionId;
        this.release = release;
        this.version = version;
        this.userId = userId;
        this.metadata = metadata;
        this.tags = tags;
        this.public_ = public_;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @Override
    @JsonProperty(value="output")
    public Optional<Object> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="sessionId")
    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="release")
    public Optional<String> getRelease() {
        return this.release;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="userId")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="tags")
    public Optional<List<String>> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="public")
    public Optional<Boolean> getPublic() {
        return this.public_;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Trace && this.equalTo((Trace)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Trace other) {
        return this.id.equals(other.id) && this.timestamp.equals(other.timestamp) && this.name.equals(other.name) && this.input.equals(other.input) && this.output.equals(other.output) && this.sessionId.equals(other.sessionId) && this.release.equals(other.release) && this.version.equals(other.version) && this.userId.equals(other.userId) && this.metadata.equals(other.metadata) && this.tags.equals(other.tags) && this.public_.equals(other.public_) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timestamp, this.name, this.input, this.output, this.sessionId, this.release, this.version, this.userId, this.metadata, this.tags, this.public_, this.environment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TimestampStage,
    _FinalStage {
        private String id;
        private OffsetDateTime timestamp;
        private Optional<String> environment = Optional.empty();
        private Optional<Boolean> public_ = Optional.empty();
        private Optional<List<String>> tags = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> release = Optional.empty();
        private Optional<String> sessionId = Optional.empty();
        private Optional<Object> output = Optional.empty();
        private Optional<Object> input = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Trace other) {
            this.id(other.getId());
            this.timestamp(other.getTimestamp());
            this.name(other.getName());
            this.input(other.getInput());
            this.output(other.getOutput());
            this.sessionId(other.getSessionId());
            this.release(other.getRelease());
            this.version(other.getVersion());
            this.userId(other.getUserId());
            this.metadata(other.getMetadata());
            this.tags(other.getTags());
            this.public_(other.getPublic());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TimestampStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @Override
        @JsonSetter(value="public", nulls=Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @Override
        public _FinalStage tags(List<String> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<List<String>> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="userId", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<String> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage release(String release) {
            this.release = Optional.ofNullable(release);
            return this;
        }

        @Override
        @JsonSetter(value="release", nulls=Nulls.SKIP)
        public _FinalStage release(Optional<String> release) {
            this.release = release;
            return this;
        }

        @Override
        public _FinalStage sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @Override
        @JsonSetter(value="sessionId", nulls=Nulls.SKIP)
        public _FinalStage sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public _FinalStage output(Object output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @Override
        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public _FinalStage output(Optional<Object> output) {
            this.output = output;
            return this;
        }

        @Override
        public _FinalStage input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public Trace build() {
            return new Trace(this.id, this.timestamp, this.name, this.input, this.output, this.sessionId, this.release, this.version, this.userId, this.metadata, this.tags, this.public_, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Trace build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage input(Optional<Object> var1);

        public _FinalStage input(Object var1);

        public _FinalStage output(Optional<Object> var1);

        public _FinalStage output(Object var1);

        public _FinalStage sessionId(Optional<String> var1);

        public _FinalStage sessionId(String var1);

        public _FinalStage release(Optional<String> var1);

        public _FinalStage release(String var1);

        public _FinalStage version(Optional<String> var1);

        public _FinalStage version(String var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage tags(Optional<List<String>> var1);

        public _FinalStage tags(List<String> var1);

        public _FinalStage public_(Optional<Boolean> var1);

        public _FinalStage public_(Boolean var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface TimestampStage {
        public _FinalStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public TimestampStage id(@NotNull String var1);

        public Builder from(Trace var1);
    }
}

