/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.langfuse.client.resources.commons.types.BooleanScore;
import com.langfuse.client.resources.commons.types.CategoricalScore;
import com.langfuse.client.resources.commons.types.NumericScore;
import java.util.Objects;
import java.util.Optional;

public final class Score {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Score(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static Score numeric(NumericScore value) {
        return new Score(new NumericValue(value));
    }

    public static Score categorical(CategoricalScore value) {
        return new Score(new CategoricalValue(value));
    }

    public static Score boolean_(BooleanScore value) {
        return new Score(new BooleanValue(value));
    }

    public boolean isNumeric() {
        return this.value instanceof NumericValue;
    }

    public boolean isCategorical() {
        return this.value instanceof CategoricalValue;
    }

    public boolean isBoolean() {
        return this.value instanceof BooleanValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<NumericScore> getNumeric() {
        if (this.isNumeric()) {
            return Optional.of(((NumericValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CategoricalScore> getCategorical() {
        if (this.isCategorical()) {
            return Optional.of(((CategoricalValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<BooleanScore> getBoolean() {
        if (this.isBoolean()) {
            return Optional.of(((BooleanValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="dataType", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=NumericValue.class), @JsonSubTypes.Type(value=CategoricalValue.class), @JsonSubTypes.Type(value=BooleanValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitNumeric(NumericScore var1);

        public T visitCategorical(CategoricalScore var1);

        public T visitBoolean(BooleanScore var1);

        public T _visitUnknown(Object var1);
    }

    @JsonTypeName(value="NUMERIC")
    @JsonIgnoreProperties(value={"dataType"})
    private static final class NumericValue
    implements Value {
        @JsonUnwrapped
        private NumericScore value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NumericValue() {
        }

        private NumericValue(NumericScore value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNumeric(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof NumericValue && this.equalTo((NumericValue)other);
        }

        private boolean equalTo(NumericValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Score{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="CATEGORICAL")
    @JsonIgnoreProperties(value={"dataType"})
    private static final class CategoricalValue
    implements Value {
        @JsonUnwrapped
        private CategoricalScore value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CategoricalValue() {
        }

        private CategoricalValue(CategoricalScore value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCategorical(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CategoricalValue && this.equalTo((CategoricalValue)other);
        }

        private boolean equalTo(CategoricalValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Score{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="BOOLEAN")
    @JsonIgnoreProperties(value={"dataType"})
    private static final class BooleanValue
    implements Value {
        @JsonUnwrapped
        private BooleanScore value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BooleanValue() {
        }

        private BooleanValue(BooleanScore value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitBoolean(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof BooleanValue && this.equalTo((BooleanValue)other);
        }

        private boolean equalTo(BooleanValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Score{value: " + this.value + "}";
        }
    }

    @JsonIgnoreProperties(value={"dataType"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "Score{type: " + this.type + ", value: " + this.value + "}";
        }
    }
}

