/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.IBaseScore;
import com.langfuse.client.resources.commons.types.INumericScore;
import com.langfuse.client.resources.commons.types.ScoreSource;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NumericScore
implements INumericScore,
IBaseScore {
    private final double value;
    private final String id;
    private final Optional<String> traceId;
    private final Optional<String> sessionId;
    private final Optional<String> observationId;
    private final Optional<String> datasetRunId;
    private final String name;
    private final ScoreSource source;
    private final OffsetDateTime timestamp;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Optional<String> authorUserId;
    private final Optional<String> comment;
    private final Optional<Object> metadata;
    private final Optional<String> configId;
    private final Optional<String> queueId;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private NumericScore(double value, String id, Optional<String> traceId, Optional<String> sessionId, Optional<String> observationId, Optional<String> datasetRunId, String name, ScoreSource source, OffsetDateTime timestamp, OffsetDateTime createdAt, OffsetDateTime updatedAt, Optional<String> authorUserId, Optional<String> comment, Optional<Object> metadata, Optional<String> configId, Optional<String> queueId, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.value = value;
        this.id = id;
        this.traceId = traceId;
        this.sessionId = sessionId;
        this.observationId = observationId;
        this.datasetRunId = datasetRunId;
        this.name = name;
        this.source = source;
        this.timestamp = timestamp;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.authorUserId = authorUserId;
        this.comment = comment;
        this.metadata = metadata;
        this.configId = configId;
        this.queueId = queueId;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="value")
    public double getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="sessionId")
    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @Override
    @JsonProperty(value="datasetRunId")
    public Optional<String> getDatasetRunId() {
        return this.datasetRunId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="source")
    public ScoreSource getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="authorUserId")
    public Optional<String> getAuthorUserId() {
        return this.authorUserId;
    }

    @Override
    @JsonProperty(value="comment")
    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="configId")
    public Optional<String> getConfigId() {
        return this.configId;
    }

    @Override
    @JsonProperty(value="queueId")
    public Optional<String> getQueueId() {
        return this.queueId;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NumericScore && this.equalTo((NumericScore)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NumericScore other) {
        return this.value == other.value && this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.sessionId.equals(other.sessionId) && this.observationId.equals(other.observationId) && this.datasetRunId.equals(other.datasetRunId) && this.name.equals(other.name) && this.source.equals((Object)other.source) && this.timestamp.equals(other.timestamp) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.authorUserId.equals(other.authorUserId) && this.comment.equals(other.comment) && this.metadata.equals(other.metadata) && this.configId.equals(other.configId) && this.queueId.equals(other.queueId) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.id, this.traceId, this.sessionId, this.observationId, this.datasetRunId, this.name, this.source, this.timestamp, this.createdAt, this.updatedAt, this.authorUserId, this.comment, this.metadata, this.configId, this.queueId, this.environment});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ValueStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ValueStage,
    IdStage,
    NameStage,
    SourceStage,
    TimestampStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private double value;
        private String id;
        private String name;
        private ScoreSource source;
        private OffsetDateTime timestamp;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<String> environment = Optional.empty();
        private Optional<String> queueId = Optional.empty();
        private Optional<String> configId = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> comment = Optional.empty();
        private Optional<String> authorUserId = Optional.empty();
        private Optional<String> datasetRunId = Optional.empty();
        private Optional<String> observationId = Optional.empty();
        private Optional<String> sessionId = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(NumericScore other) {
            this.value(other.getValue());
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.sessionId(other.getSessionId());
            this.observationId(other.getObservationId());
            this.datasetRunId(other.getDatasetRunId());
            this.name(other.getName());
            this.source(other.getSource());
            this.timestamp(other.getTimestamp());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.authorUserId(other.getAuthorUserId());
            this.comment(other.getComment());
            this.metadata(other.getMetadata());
            this.configId(other.getConfigId());
            this.queueId(other.getQueueId());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public IdStage value(double value) {
            this.value = value;
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public SourceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source")
        public TimestampStage source(@NotNull ScoreSource source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public CreatedAtStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage queueId(String queueId) {
            this.queueId = Optional.ofNullable(queueId);
            return this;
        }

        @Override
        @JsonSetter(value="queueId", nulls=Nulls.SKIP)
        public _FinalStage queueId(Optional<String> queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public _FinalStage configId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        @Override
        @JsonSetter(value="configId", nulls=Nulls.SKIP)
        public _FinalStage configId(Optional<String> configId) {
            this.configId = configId;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @Override
        @JsonSetter(value="comment", nulls=Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public _FinalStage authorUserId(String authorUserId) {
            this.authorUserId = Optional.ofNullable(authorUserId);
            return this;
        }

        @Override
        @JsonSetter(value="authorUserId", nulls=Nulls.SKIP)
        public _FinalStage authorUserId(Optional<String> authorUserId) {
            this.authorUserId = authorUserId;
            return this;
        }

        @Override
        public _FinalStage datasetRunId(String datasetRunId) {
            this.datasetRunId = Optional.ofNullable(datasetRunId);
            return this;
        }

        @Override
        @JsonSetter(value="datasetRunId", nulls=Nulls.SKIP)
        public _FinalStage datasetRunId(Optional<String> datasetRunId) {
            this.datasetRunId = datasetRunId;
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public _FinalStage sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @Override
        @JsonSetter(value="sessionId", nulls=Nulls.SKIP)
        public _FinalStage sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public _FinalStage traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @Override
        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public _FinalStage traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public NumericScore build() {
            return new NumericScore(this.value, this.id, this.traceId, this.sessionId, this.observationId, this.datasetRunId, this.name, this.source, this.timestamp, this.createdAt, this.updatedAt, this.authorUserId, this.comment, this.metadata, this.configId, this.queueId, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public NumericScore build();

        public _FinalStage traceId(Optional<String> var1);

        public _FinalStage traceId(String var1);

        public _FinalStage sessionId(Optional<String> var1);

        public _FinalStage sessionId(String var1);

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);

        public _FinalStage datasetRunId(Optional<String> var1);

        public _FinalStage datasetRunId(String var1);

        public _FinalStage authorUserId(Optional<String> var1);

        public _FinalStage authorUserId(String var1);

        public _FinalStage comment(Optional<String> var1);

        public _FinalStage comment(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage configId(Optional<String> var1);

        public _FinalStage configId(String var1);

        public _FinalStage queueId(Optional<String> var1);

        public _FinalStage queueId(String var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface TimestampStage {
        public CreatedAtStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface SourceStage {
        public TimestampStage source(@NotNull ScoreSource var1);
    }

    public static interface NameStage {
        public SourceStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface ValueStage {
        public IdStage value(double var1);

        public Builder from(NumericScore var1);
    }
}

