/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
public final class MapValue {
    private final Object value;
    private final int type;

    private MapValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visitOptionalString((Optional)this.value);
        }
        if (this.type == 1) {
            return visitor.visitOptionalInteger((Optional)this.value);
        }
        if (this.type == 2) {
            return visitor.visitOptionalBoolean((Optional)this.value);
        }
        if (this.type == 3) {
            return visitor.visitOptionalListOfString((Optional)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MapValue && this.equalTo((MapValue)other);
    }

    private boolean equalTo(MapValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static MapValue ofOptionalString(Optional<String> value) {
        return new MapValue(value, 0);
    }

    public static MapValue ofOptionalInteger(Optional<Integer> value) {
        return new MapValue(value, 1);
    }

    public static MapValue ofOptionalBoolean(Optional<Boolean> value) {
        return new MapValue(value, 2);
    }

    public static MapValue ofOptionalListOfString(Optional<List<String>> value) {
        return new MapValue(value, 3);
    }

    public static interface Visitor<T> {
        public T visitOptionalString(Optional<String> var1);

        public T visitOptionalInteger(Optional<Integer> var1);

        public T visitOptionalBoolean(Optional<Boolean> var1);

        public T visitOptionalListOfString(Optional<List<String>> var1);
    }

    static final class Deserializer
    extends StdDeserializer<MapValue> {
        Deserializer() {
            super(MapValue.class);
        }

        public MapValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return MapValue.ofOptionalString((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<String>>(){}));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return MapValue.ofOptionalInteger((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<Integer>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return MapValue.ofOptionalBoolean((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<Boolean>>(){}));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            return MapValue.ofOptionalListOfString((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<List<String>>>(){}));
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }
    }
}

