/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.DatasetStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DatasetItem {
    private final String id;
    private final DatasetStatus status;
    private final Optional<Object> input;
    private final Optional<Object> expectedOutput;
    private final Optional<Object> metadata;
    private final Optional<String> sourceTraceId;
    private final Optional<String> sourceObservationId;
    private final String datasetId;
    private final String datasetName;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private DatasetItem(String id, DatasetStatus status, Optional<Object> input, Optional<Object> expectedOutput, Optional<Object> metadata, Optional<String> sourceTraceId, Optional<String> sourceObservationId, String datasetId, String datasetName, OffsetDateTime createdAt, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.input = input;
        this.expectedOutput = expectedOutput;
        this.metadata = metadata;
        this.sourceTraceId = sourceTraceId;
        this.sourceObservationId = sourceObservationId;
        this.datasetId = datasetId;
        this.datasetName = datasetName;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public DatasetStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @JsonProperty(value="expectedOutput")
    public Optional<Object> getExpectedOutput() {
        return this.expectedOutput;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="sourceTraceId")
    public Optional<String> getSourceTraceId() {
        return this.sourceTraceId;
    }

    @JsonProperty(value="sourceObservationId")
    public Optional<String> getSourceObservationId() {
        return this.sourceObservationId;
    }

    @JsonProperty(value="datasetId")
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetName")
    public String getDatasetName() {
        return this.datasetName;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetItem && this.equalTo((DatasetItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetItem other) {
        return this.id.equals(other.id) && this.status.equals((Object)other.status) && this.input.equals(other.input) && this.expectedOutput.equals(other.expectedOutput) && this.metadata.equals(other.metadata) && this.sourceTraceId.equals(other.sourceTraceId) && this.sourceObservationId.equals(other.sourceObservationId) && this.datasetId.equals(other.datasetId) && this.datasetName.equals(other.datasetName) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.input, this.expectedOutput, this.metadata, this.sourceTraceId, this.sourceObservationId, this.datasetId, this.datasetName, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    StatusStage,
    DatasetIdStage,
    DatasetNameStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private DatasetStatus status;
        private String datasetId;
        private String datasetName;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<String> sourceObservationId = Optional.empty();
        private Optional<String> sourceTraceId = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<Object> expectedOutput = Optional.empty();
        private Optional<Object> input = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DatasetItem other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.input(other.getInput());
            this.expectedOutput(other.getExpectedOutput());
            this.metadata(other.getMetadata());
            this.sourceTraceId(other.getSourceTraceId());
            this.sourceObservationId(other.getSourceObservationId());
            this.datasetId(other.getDatasetId());
            this.datasetName(other.getDatasetName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public StatusStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public DatasetIdStage status(@NotNull DatasetStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetId")
        public DatasetNameStage datasetId(@NotNull String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetName")
        public CreatedAtStage datasetName(@NotNull String datasetName) {
            this.datasetName = Objects.requireNonNull(datasetName, "datasetName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage sourceObservationId(String sourceObservationId) {
            this.sourceObservationId = Optional.ofNullable(sourceObservationId);
            return this;
        }

        @Override
        @JsonSetter(value="sourceObservationId", nulls=Nulls.SKIP)
        public _FinalStage sourceObservationId(Optional<String> sourceObservationId) {
            this.sourceObservationId = sourceObservationId;
            return this;
        }

        @Override
        public _FinalStage sourceTraceId(String sourceTraceId) {
            this.sourceTraceId = Optional.ofNullable(sourceTraceId);
            return this;
        }

        @Override
        @JsonSetter(value="sourceTraceId", nulls=Nulls.SKIP)
        public _FinalStage sourceTraceId(Optional<String> sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage expectedOutput(Object expectedOutput) {
            this.expectedOutput = Optional.ofNullable(expectedOutput);
            return this;
        }

        @Override
        @JsonSetter(value="expectedOutput", nulls=Nulls.SKIP)
        public _FinalStage expectedOutput(Optional<Object> expectedOutput) {
            this.expectedOutput = expectedOutput;
            return this;
        }

        @Override
        public _FinalStage input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        @Override
        public DatasetItem build() {
            return new DatasetItem(this.id, this.status, this.input, this.expectedOutput, this.metadata, this.sourceTraceId, this.sourceObservationId, this.datasetId, this.datasetName, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DatasetItem build();

        public _FinalStage input(Optional<Object> var1);

        public _FinalStage input(Object var1);

        public _FinalStage expectedOutput(Optional<Object> var1);

        public _FinalStage expectedOutput(Object var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage sourceTraceId(Optional<String> var1);

        public _FinalStage sourceTraceId(String var1);

        public _FinalStage sourceObservationId(Optional<String> var1);

        public _FinalStage sourceObservationId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface DatasetNameStage {
        public CreatedAtStage datasetName(@NotNull String var1);
    }

    public static interface DatasetIdStage {
        public DatasetNameStage datasetId(@NotNull String var1);
    }

    public static interface StatusStage {
        public DatasetIdStage status(@NotNull DatasetStatus var1);
    }

    public static interface IdStage {
        public StatusStage id(@NotNull String var1);

        public Builder from(DatasetItem var1);
    }
}

