/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class CreateScoreValue {
    private final Object value;
    private final int type;

    private CreateScoreValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Double)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((String)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateScoreValue && this.equalTo((CreateScoreValue)other);
    }

    private boolean equalTo(CreateScoreValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static CreateScoreValue of(double value) {
        return new CreateScoreValue(value, 0);
    }

    public static CreateScoreValue of(String value) {
        return new CreateScoreValue(value, 1);
    }

    public static interface Visitor<T> {
        public T visit(double var1);

        public T visit(String var1);
    }

    static final class Deserializer
    extends StdDeserializer<CreateScoreValue> {
        Deserializer() {
            super(CreateScoreValue.class);
        }

        public CreateScoreValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            if (value instanceof Double) {
                return CreateScoreValue.of((Double)value);
            }
            try {
                return CreateScoreValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}

