/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConfigCategory {
    private final double value;
    private final String label;
    private final Map<String, Object> additionalProperties;

    private ConfigCategory(double value, String label, Map<String, Object> additionalProperties) {
        this.value = value;
        this.label = label;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="value")
    public double getValue() {
        return this.value;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConfigCategory && this.equalTo((ConfigCategory)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConfigCategory other) {
        return this.value == other.value && this.label.equals(other.label);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.label);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ValueStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ValueStage,
    LabelStage,
    _FinalStage {
        private double value;
        private String label;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConfigCategory other) {
            this.value(other.getValue());
            this.label(other.getLabel());
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public LabelStage value(double value) {
            this.value = value;
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public _FinalStage label(@NotNull String label) {
            this.label = Objects.requireNonNull(label, "label must not be null");
            return this;
        }

        @Override
        public ConfigCategory build() {
            return new ConfigCategory(this.value, this.label, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConfigCategory build();
    }

    public static interface LabelStage {
        public _FinalStage label(@NotNull String var1);
    }

    public static interface ValueStage {
        public LabelStage value(double var1);

        public Builder from(ConfigCategory var1);
    }
}

