/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.CommentObjectType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Comment {
    private final String id;
    private final String projectId;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final CommentObjectType objectType;
    private final String objectId;
    private final String content;
    private final Optional<String> authorUserId;
    private final Map<String, Object> additionalProperties;

    private Comment(String id, String projectId, OffsetDateTime createdAt, OffsetDateTime updatedAt, CommentObjectType objectType, String objectId, String content, Optional<String> authorUserId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.projectId = projectId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.objectType = objectType;
        this.objectId = objectId;
        this.content = content;
        this.authorUserId = authorUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="projectId")
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="objectType")
    public CommentObjectType getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="objectId")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="authorUserId")
    public Optional<String> getAuthorUserId() {
        return this.authorUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Comment && this.equalTo((Comment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Comment other) {
        return this.id.equals(other.id) && this.projectId.equals(other.projectId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.objectType.equals((Object)other.objectType) && this.objectId.equals(other.objectId) && this.content.equals(other.content) && this.authorUserId.equals(other.authorUserId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.projectId, this.createdAt, this.updatedAt, this.objectType, this.objectId, this.content, this.authorUserId});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ProjectIdStage,
    CreatedAtStage,
    UpdatedAtStage,
    ObjectTypeStage,
    ObjectIdStage,
    ContentStage,
    _FinalStage {
        private String id;
        private String projectId;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private CommentObjectType objectType;
        private String objectId;
        private String content;
        private Optional<String> authorUserId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Comment other) {
            this.id(other.getId());
            this.projectId(other.getProjectId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.objectType(other.getObjectType());
            this.objectId(other.getObjectId());
            this.content(other.getContent());
            this.authorUserId(other.getAuthorUserId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ProjectIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="projectId")
        public CreatedAtStage projectId(@NotNull String projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public ObjectTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectType")
        public ObjectIdStage objectType(@NotNull CommentObjectType objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectId")
        public ContentStage objectId(@NotNull String objectId) {
            this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(@NotNull String content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @Override
        public _FinalStage authorUserId(String authorUserId) {
            this.authorUserId = Optional.ofNullable(authorUserId);
            return this;
        }

        @Override
        @JsonSetter(value="authorUserId", nulls=Nulls.SKIP)
        public _FinalStage authorUserId(Optional<String> authorUserId) {
            this.authorUserId = authorUserId;
            return this;
        }

        @Override
        public Comment build() {
            return new Comment(this.id, this.projectId, this.createdAt, this.updatedAt, this.objectType, this.objectId, this.content, this.authorUserId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Comment build();

        public _FinalStage authorUserId(Optional<String> var1);

        public _FinalStage authorUserId(String var1);
    }

    public static interface ContentStage {
        public _FinalStage content(@NotNull String var1);
    }

    public static interface ObjectIdStage {
        public ContentStage objectId(@NotNull String var1);
    }

    public static interface ObjectTypeStage {
        public ObjectIdStage objectType(@NotNull CommentObjectType var1);
    }

    public static interface UpdatedAtStage {
        public ObjectTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface ProjectIdStage {
        public CreatedAtStage projectId(@NotNull String var1);
    }

    public static interface IdStage {
        public ProjectIdStage id(@NotNull String var1);

        public Builder from(Comment var1);
    }
}

