/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.score.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import com.langfuse.client.resources.commons.types.CreateScoreValue;
import com.langfuse.client.resources.commons.types.ScoreDataType;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateScoreRequest.Builder.class
)
public final class CreateScoreRequest {
  private final Optional<String> id;

  private final Optional<String> traceId;

  private final Optional<String> sessionId;

  private final Optional<String> observationId;

  private final Optional<String> datasetRunId;

  private final String name;

  private final CreateScoreValue value;

  private final Optional<String> comment;

  private final Optional<Object> metadata;

  private final Optional<String> environment;

  private final Optional<ScoreDataType> dataType;

  private final Optional<String> configId;

  private final Map<String, Object> additionalProperties;

  private CreateScoreRequest(Optional<String> id, Optional<String> traceId,
      Optional<String> sessionId, Optional<String> observationId, Optional<String> datasetRunId,
      String name, CreateScoreValue value, Optional<String> comment, Optional<Object> metadata,
      Optional<String> environment, Optional<ScoreDataType> dataType, Optional<String> configId,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.traceId = traceId;
    this.sessionId = sessionId;
    this.observationId = observationId;
    this.datasetRunId = datasetRunId;
    this.name = name;
    this.value = value;
    this.comment = comment;
    this.metadata = metadata;
    this.environment = environment;
    this.dataType = dataType;
    this.configId = configId;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  @JsonProperty("traceId")
  public Optional<String> getTraceId() {
    return traceId;
  }

  @JsonProperty("sessionId")
  public Optional<String> getSessionId() {
    return sessionId;
  }

  @JsonProperty("observationId")
  public Optional<String> getObservationId() {
    return observationId;
  }

  @JsonProperty("datasetRunId")
  public Optional<String> getDatasetRunId() {
    return datasetRunId;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return The value of the score. Must be passed as string for categorical scores, and numeric for boolean and numeric scores. Boolean score values must equal either 1 or 0 (true or false)
   */
  @JsonProperty("value")
  public CreateScoreValue getValue() {
    return value;
  }

  @JsonProperty("comment")
  public Optional<String> getComment() {
    return comment;
  }

  @JsonProperty("metadata")
  public Optional<Object> getMetadata() {
    return metadata;
  }

  /**
   * @return The environment of the score. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.
   */
  @JsonProperty("environment")
  public Optional<String> getEnvironment() {
    return environment;
  }

  /**
   * @return The data type of the score. When passing a configId this field is inferred. Otherwise, this field must be passed or will default to numeric.
   */
  @JsonProperty("dataType")
  public Optional<ScoreDataType> getDataType() {
    return dataType;
  }

  /**
   * @return Reference a score config on a score. The unique langfuse identifier of a score config. When passing this field, the dataType and stringValue fields are automatically populated.
   */
  @JsonProperty("configId")
  public Optional<String> getConfigId() {
    return configId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateScoreRequest && equalTo((CreateScoreRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateScoreRequest other) {
    return id.equals(other.id) && traceId.equals(other.traceId) && sessionId.equals(other.sessionId) && observationId.equals(other.observationId) && datasetRunId.equals(other.datasetRunId) && name.equals(other.name) && value.equals(other.value) && comment.equals(other.comment) && metadata.equals(other.metadata) && environment.equals(other.environment) && dataType.equals(other.dataType) && configId.equals(other.configId);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.traceId, this.sessionId, this.observationId, this.datasetRunId, this.name, this.value, this.comment, this.metadata, this.environment, this.dataType, this.configId);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    ValueStage name(@NotNull String name);

    Builder from(CreateScoreRequest other);
  }

  public interface ValueStage {
    _FinalStage value(@NotNull CreateScoreValue value);
  }

  public interface _FinalStage {
    CreateScoreRequest build();

    _FinalStage id(Optional<String> id);

    _FinalStage id(String id);

    _FinalStage traceId(Optional<String> traceId);

    _FinalStage traceId(String traceId);

    _FinalStage sessionId(Optional<String> sessionId);

    _FinalStage sessionId(String sessionId);

    _FinalStage observationId(Optional<String> observationId);

    _FinalStage observationId(String observationId);

    _FinalStage datasetRunId(Optional<String> datasetRunId);

    _FinalStage datasetRunId(String datasetRunId);

    _FinalStage comment(Optional<String> comment);

    _FinalStage comment(String comment);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage environment(Optional<String> environment);

    _FinalStage environment(String environment);

    _FinalStage dataType(Optional<ScoreDataType> dataType);

    _FinalStage dataType(ScoreDataType dataType);

    _FinalStage configId(Optional<String> configId);

    _FinalStage configId(String configId);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, ValueStage, _FinalStage {
    private String name;

    private CreateScoreValue value;

    private Optional<String> configId = Optional.empty();

    private Optional<ScoreDataType> dataType = Optional.empty();

    private Optional<String> environment = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> comment = Optional.empty();

    private Optional<String> datasetRunId = Optional.empty();

    private Optional<String> observationId = Optional.empty();

    private Optional<String> sessionId = Optional.empty();

    private Optional<String> traceId = Optional.empty();

    private Optional<String> id = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateScoreRequest other) {
      id(other.getId());
      traceId(other.getTraceId());
      sessionId(other.getSessionId());
      observationId(other.getObservationId());
      datasetRunId(other.getDatasetRunId());
      name(other.getName());
      value(other.getValue());
      comment(other.getComment());
      metadata(other.getMetadata());
      environment(other.getEnvironment());
      dataType(other.getDataType());
      configId(other.getConfigId());
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public ValueStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>The value of the score. Must be passed as string for categorical scores, and numeric for boolean and numeric scores. Boolean score values must equal either 1 or 0 (true or false)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("value")
    public _FinalStage value(@NotNull CreateScoreValue value) {
      this.value = Objects.requireNonNull(value, "value must not be null");
      return this;
    }

    /**
     * <p>Reference a score config on a score. The unique langfuse identifier of a score config. When passing this field, the dataType and stringValue fields are automatically populated.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage configId(String configId) {
      this.configId = Optional.ofNullable(configId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "configId",
        nulls = Nulls.SKIP
    )
    public _FinalStage configId(Optional<String> configId) {
      this.configId = configId;
      return this;
    }

    /**
     * <p>The data type of the score. When passing a configId this field is inferred. Otherwise, this field must be passed or will default to numeric.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage dataType(ScoreDataType dataType) {
      this.dataType = Optional.ofNullable(dataType);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "dataType",
        nulls = Nulls.SKIP
    )
    public _FinalStage dataType(Optional<ScoreDataType> dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * <p>The environment of the score. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public _FinalStage environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    @java.lang.Override
    public _FinalStage comment(String comment) {
      this.comment = Optional.ofNullable(comment);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "comment",
        nulls = Nulls.SKIP
    )
    public _FinalStage comment(Optional<String> comment) {
      this.comment = comment;
      return this;
    }

    @java.lang.Override
    public _FinalStage datasetRunId(String datasetRunId) {
      this.datasetRunId = Optional.ofNullable(datasetRunId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "datasetRunId",
        nulls = Nulls.SKIP
    )
    public _FinalStage datasetRunId(Optional<String> datasetRunId) {
      this.datasetRunId = datasetRunId;
      return this;
    }

    @java.lang.Override
    public _FinalStage observationId(String observationId) {
      this.observationId = Optional.ofNullable(observationId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "observationId",
        nulls = Nulls.SKIP
    )
    public _FinalStage observationId(Optional<String> observationId) {
      this.observationId = observationId;
      return this;
    }

    @java.lang.Override
    public _FinalStage sessionId(String sessionId) {
      this.sessionId = Optional.ofNullable(sessionId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "sessionId",
        nulls = Nulls.SKIP
    )
    public _FinalStage sessionId(Optional<String> sessionId) {
      this.sessionId = sessionId;
      return this;
    }

    @java.lang.Override
    public _FinalStage traceId(String traceId) {
      this.traceId = Optional.ofNullable(traceId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "traceId",
        nulls = Nulls.SKIP
    )
    public _FinalStage traceId(Optional<String> traceId) {
      this.traceId = traceId;
      return this;
    }

    @java.lang.Override
    public _FinalStage id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public _FinalStage id(Optional<String> id) {
      this.id = id;
      return this;
    }

    @java.lang.Override
    public CreateScoreRequest build() {
      return new CreateScoreRequest(id, traceId, sessionId, observationId, datasetRunId, name, value, comment, metadata, environment, dataType, configId, additionalProperties);
    }
  }
}
