/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UserMeta.Builder.class
)
public final class UserMeta {
  private final String resourceType;

  private final Optional<String> created;

  private final Optional<String> lastModified;

  private final Map<String, Object> additionalProperties;

  private UserMeta(String resourceType, Optional<String> created, Optional<String> lastModified,
      Map<String, Object> additionalProperties) {
    this.resourceType = resourceType;
    this.created = created;
    this.lastModified = lastModified;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("resourceType")
  public String getResourceType() {
    return resourceType;
  }

  @JsonProperty("created")
  public Optional<String> getCreated() {
    return created;
  }

  @JsonProperty("lastModified")
  public Optional<String> getLastModified() {
    return lastModified;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UserMeta && equalTo((UserMeta) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UserMeta other) {
    return resourceType.equals(other.resourceType) && created.equals(other.created) && lastModified.equals(other.lastModified);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.resourceType, this.created, this.lastModified);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ResourceTypeStage builder() {
    return new Builder();
  }

  public interface ResourceTypeStage {
    _FinalStage resourceType(@NotNull String resourceType);

    Builder from(UserMeta other);
  }

  public interface _FinalStage {
    UserMeta build();

    _FinalStage created(Optional<String> created);

    _FinalStage created(String created);

    _FinalStage lastModified(Optional<String> lastModified);

    _FinalStage lastModified(String lastModified);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ResourceTypeStage, _FinalStage {
    private String resourceType;

    private Optional<String> lastModified = Optional.empty();

    private Optional<String> created = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(UserMeta other) {
      resourceType(other.getResourceType());
      created(other.getCreated());
      lastModified(other.getLastModified());
      return this;
    }

    @java.lang.Override
    @JsonSetter("resourceType")
    public _FinalStage resourceType(@NotNull String resourceType) {
      this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage lastModified(String lastModified) {
      this.lastModified = Optional.ofNullable(lastModified);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "lastModified",
        nulls = Nulls.SKIP
    )
    public _FinalStage lastModified(Optional<String> lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    @java.lang.Override
    public _FinalStage created(String created) {
      this.created = Optional.ofNullable(created);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "created",
        nulls = Nulls.SKIP
    )
    public _FinalStage created(Optional<String> created) {
      this.created = created;
      return this;
    }

    @java.lang.Override
    public UserMeta build() {
      return new UserMeta(resourceType, created, lastModified, additionalProperties);
    }
  }
}
