/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ScimEmail.Builder.class
)
public final class ScimEmail {
  private final boolean primary;

  private final String value;

  private final String type;

  private final Map<String, Object> additionalProperties;

  private ScimEmail(boolean primary, String value, String type,
      Map<String, Object> additionalProperties) {
    this.primary = primary;
    this.value = value;
    this.type = type;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("primary")
  public boolean getPrimary() {
    return primary;
  }

  @JsonProperty("value")
  public String getValue() {
    return value;
  }

  @JsonProperty("type")
  public String getType() {
    return type;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ScimEmail && equalTo((ScimEmail) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ScimEmail other) {
    return primary == other.primary && value.equals(other.value) && type.equals(other.type);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.primary, this.value, this.type);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static PrimaryStage builder() {
    return new Builder();
  }

  public interface PrimaryStage {
    ValueStage primary(boolean primary);

    Builder from(ScimEmail other);
  }

  public interface ValueStage {
    TypeStage value(@NotNull String value);
  }

  public interface TypeStage {
    _FinalStage type(@NotNull String type);
  }

  public interface _FinalStage {
    ScimEmail build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements PrimaryStage, ValueStage, TypeStage, _FinalStage {
    private boolean primary;

    private String value;

    private String type;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ScimEmail other) {
      primary(other.getPrimary());
      value(other.getValue());
      type(other.getType());
      return this;
    }

    @java.lang.Override
    @JsonSetter("primary")
    public ValueStage primary(boolean primary) {
      this.primary = primary;
      return this;
    }

    @java.lang.Override
    @JsonSetter("value")
    public TypeStage value(@NotNull String value) {
      this.value = Objects.requireNonNull(value, "value must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("type")
    public _FinalStage type(@NotNull String type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    @java.lang.Override
    public ScimEmail build() {
      return new ScimEmail(primary, value, type, additionalProperties);
    }
  }
}
