/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ResourceType.Builder.class
)
public final class ResourceType {
  private final Optional<List<String>> schemas;

  private final String id;

  private final String name;

  private final String endpoint;

  private final String description;

  private final String schema;

  private final List<SchemaExtension> schemaExtensions;

  private final ResourceMeta meta;

  private final Map<String, Object> additionalProperties;

  private ResourceType(Optional<List<String>> schemas, String id, String name, String endpoint,
      String description, String schema, List<SchemaExtension> schemaExtensions, ResourceMeta meta,
      Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.id = id;
    this.name = name;
    this.endpoint = endpoint;
    this.description = description;
    this.schema = schema;
    this.schemaExtensions = schemaExtensions;
    this.meta = meta;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public Optional<List<String>> getSchemas() {
    return schemas;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("endpoint")
  public String getEndpoint() {
    return endpoint;
  }

  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("schema")
  public String getSchema() {
    return schema;
  }

  @JsonProperty("schemaExtensions")
  public List<SchemaExtension> getSchemaExtensions() {
    return schemaExtensions;
  }

  @JsonProperty("meta")
  public ResourceMeta getMeta() {
    return meta;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ResourceType && equalTo((ResourceType) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ResourceType other) {
    return schemas.equals(other.schemas) && id.equals(other.id) && name.equals(other.name) && endpoint.equals(other.endpoint) && description.equals(other.description) && schema.equals(other.schema) && schemaExtensions.equals(other.schemaExtensions) && meta.equals(other.meta);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.id, this.name, this.endpoint, this.description, this.schema, this.schemaExtensions, this.meta);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(ResourceType other);
  }

  public interface NameStage {
    EndpointStage name(@NotNull String name);
  }

  public interface EndpointStage {
    DescriptionStage endpoint(@NotNull String endpoint);
  }

  public interface DescriptionStage {
    SchemaStage description(@NotNull String description);
  }

  public interface SchemaStage {
    MetaStage schema(@NotNull String schema);
  }

  public interface MetaStage {
    _FinalStage meta(@NotNull ResourceMeta meta);
  }

  public interface _FinalStage {
    ResourceType build();

    _FinalStage schemas(Optional<List<String>> schemas);

    _FinalStage schemas(List<String> schemas);

    _FinalStage schemaExtensions(List<SchemaExtension> schemaExtensions);

    _FinalStage addSchemaExtensions(SchemaExtension schemaExtensions);

    _FinalStage addAllSchemaExtensions(List<SchemaExtension> schemaExtensions);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, EndpointStage, DescriptionStage, SchemaStage, MetaStage, _FinalStage {
    private String id;

    private String name;

    private String endpoint;

    private String description;

    private String schema;

    private ResourceMeta meta;

    private List<SchemaExtension> schemaExtensions = new ArrayList<>();

    private Optional<List<String>> schemas = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ResourceType other) {
      schemas(other.getSchemas());
      id(other.getId());
      name(other.getName());
      endpoint(other.getEndpoint());
      description(other.getDescription());
      schema(other.getSchema());
      schemaExtensions(other.getSchemaExtensions());
      meta(other.getMeta());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public EndpointStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("endpoint")
    public DescriptionStage endpoint(@NotNull String endpoint) {
      this.endpoint = Objects.requireNonNull(endpoint, "endpoint must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("description")
    public SchemaStage description(@NotNull String description) {
      this.description = Objects.requireNonNull(description, "description must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("schema")
    public MetaStage schema(@NotNull String schema) {
      this.schema = Objects.requireNonNull(schema, "schema must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("meta")
    public _FinalStage meta(@NotNull ResourceMeta meta) {
      this.meta = Objects.requireNonNull(meta, "meta must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemaExtensions(List<SchemaExtension> schemaExtensions) {
      this.schemaExtensions.addAll(schemaExtensions);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemaExtensions(SchemaExtension schemaExtensions) {
      this.schemaExtensions.add(schemaExtensions);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemaExtensions",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemaExtensions(List<SchemaExtension> schemaExtensions) {
      this.schemaExtensions.clear();
      this.schemaExtensions.addAll(schemaExtensions);
      return this;
    }

    @java.lang.Override
    public _FinalStage schemas(List<String> schemas) {
      this.schemas = Optional.ofNullable(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(Optional<List<String>> schemas) {
      this.schemas = schemas;
      return this;
    }

    @java.lang.Override
    public ResourceType build() {
      return new ResourceType(schemas, id, name, endpoint, description, schema, schemaExtensions, meta, additionalProperties);
    }
  }
}
