/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ResourceMeta.Builder.class
)
public final class ResourceMeta {
  private final String resourceType;

  private final String location;

  private final Map<String, Object> additionalProperties;

  private ResourceMeta(String resourceType, String location,
      Map<String, Object> additionalProperties) {
    this.resourceType = resourceType;
    this.location = location;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("resourceType")
  public String getResourceType() {
    return resourceType;
  }

  @JsonProperty("location")
  public String getLocation() {
    return location;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ResourceMeta && equalTo((ResourceMeta) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ResourceMeta other) {
    return resourceType.equals(other.resourceType) && location.equals(other.location);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.resourceType, this.location);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ResourceTypeStage builder() {
    return new Builder();
  }

  public interface ResourceTypeStage {
    LocationStage resourceType(@NotNull String resourceType);

    Builder from(ResourceMeta other);
  }

  public interface LocationStage {
    _FinalStage location(@NotNull String location);
  }

  public interface _FinalStage {
    ResourceMeta build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ResourceTypeStage, LocationStage, _FinalStage {
    private String resourceType;

    private String location;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ResourceMeta other) {
      resourceType(other.getResourceType());
      location(other.getLocation());
      return this;
    }

    @java.lang.Override
    @JsonSetter("resourceType")
    public LocationStage resourceType(@NotNull String resourceType) {
      this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("location")
    public _FinalStage location(@NotNull String location) {
      this.location = Objects.requireNonNull(location, "location must not be null");
      return this;
    }

    @java.lang.Override
    public ResourceMeta build() {
      return new ResourceMeta(resourceType, location, additionalProperties);
    }
  }
}
