/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ListUsersRequest.Builder.class
)
public final class ListUsersRequest {
  private final Optional<String> filter;

  private final Optional<Integer> startIndex;

  private final Optional<Integer> count;

  private final Map<String, Object> additionalProperties;

  private ListUsersRequest(Optional<String> filter, Optional<Integer> startIndex,
      Optional<Integer> count, Map<String, Object> additionalProperties) {
    this.filter = filter;
    this.startIndex = startIndex;
    this.count = count;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Filter expression (e.g. userName eq &quot;value&quot;)
   */
  @JsonProperty("filter")
  public Optional<String> getFilter() {
    return filter;
  }

  /**
   * @return 1-based index of the first result to return (default 1)
   */
  @JsonProperty("startIndex")
  public Optional<Integer> getStartIndex() {
    return startIndex;
  }

  /**
   * @return Maximum number of results to return (default 100)
   */
  @JsonProperty("count")
  public Optional<Integer> getCount() {
    return count;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListUsersRequest && equalTo((ListUsersRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListUsersRequest other) {
    return filter.equals(other.filter) && startIndex.equals(other.startIndex) && count.equals(other.count);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.filter, this.startIndex, this.count);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> filter = Optional.empty();

    private Optional<Integer> startIndex = Optional.empty();

    private Optional<Integer> count = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListUsersRequest other) {
      filter(other.getFilter());
      startIndex(other.getStartIndex());
      count(other.getCount());
      return this;
    }

    @JsonSetter(
        value = "filter",
        nulls = Nulls.SKIP
    )
    public Builder filter(Optional<String> filter) {
      this.filter = filter;
      return this;
    }

    public Builder filter(String filter) {
      this.filter = Optional.ofNullable(filter);
      return this;
    }

    @JsonSetter(
        value = "startIndex",
        nulls = Nulls.SKIP
    )
    public Builder startIndex(Optional<Integer> startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    public Builder startIndex(Integer startIndex) {
      this.startIndex = Optional.ofNullable(startIndex);
      return this;
    }

    @JsonSetter(
        value = "count",
        nulls = Nulls.SKIP
    )
    public Builder count(Optional<Integer> count) {
      this.count = count;
      return this;
    }

    public Builder count(Integer count) {
      this.count = Optional.ofNullable(count);
      return this;
    }

    public ListUsersRequest build() {
      return new ListUsersRequest(filter, startIndex, count, additionalProperties);
    }
  }
}
