/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Object;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public final class CreatePromptRequest {
  private final Value value;

  @JsonCreator(
      mode = JsonCreator.Mode.DELEGATING
  )
  private CreatePromptRequest(Value value) {
    this.value = value;
  }

  public <T> T visit(Visitor<T> visitor) {
    return value.visit(visitor);
  }

  public static CreatePromptRequest chat(CreateChatPromptRequest value) {
    return new CreatePromptRequest(new ChatValue(value));
  }

  public static CreatePromptRequest text(CreateTextPromptRequest value) {
    return new CreatePromptRequest(new TextValue(value));
  }

  public boolean isChat() {
    return value instanceof ChatValue;
  }

  public boolean isText() {
    return value instanceof TextValue;
  }

  public boolean _isUnknown() {
    return value instanceof _UnknownValue;
  }

  public Optional<CreateChatPromptRequest> getChat() {
    if (isChat()) {
      return Optional.of(((ChatValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<CreateTextPromptRequest> getText() {
    if (isText()) {
      return Optional.of(((TextValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<Object> _getUnknown() {
    if (_isUnknown()) {
      return Optional.of(((_UnknownValue) value).value);
    }
    return Optional.empty();
  }

  @JsonValue
  private Value getValue() {
    return this.value;
  }

  public interface Visitor<T> {
    T visitChat(CreateChatPromptRequest chat);

    T visitText(CreateTextPromptRequest text);

    T _visitUnknown(Object unknownType);
  }

  @JsonTypeInfo(
      use = JsonTypeInfo.Id.NAME,
      property = "type",
      visible = true,
      defaultImpl = _UnknownValue.class
  )
  @JsonSubTypes({
      @JsonSubTypes.Type(ChatValue.class),
      @JsonSubTypes.Type(TextValue.class)
  })
  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  private interface Value {
    <T> T visit(Visitor<T> visitor);
  }

  @JsonTypeName("chat")
  @JsonIgnoreProperties("type")
  private static final class ChatValue implements Value {
    @JsonUnwrapped
    private CreateChatPromptRequest value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private ChatValue() {
    }

    private ChatValue(CreateChatPromptRequest value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitChat(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof ChatValue && equalTo((ChatValue) other);
    }

    private boolean equalTo(ChatValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "CreatePromptRequest{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("text")
  @JsonIgnoreProperties("type")
  private static final class TextValue implements Value {
    @JsonUnwrapped
    private CreateTextPromptRequest value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private TextValue() {
    }

    private TextValue(CreateTextPromptRequest value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitText(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof TextValue && equalTo((TextValue) other);
    }

    private boolean equalTo(TextValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "CreatePromptRequest{" + "value: " + value + "}";
    }
  }

  @JsonIgnoreProperties("type")
  private static final class _UnknownValue implements Value {
    private String type;

    @JsonValue
    private Object value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private _UnknownValue(@JsonProperty("value") Object value) {
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor._visitUnknown(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
    }

    private boolean equalTo(_UnknownValue other) {
      return type.equals(other.type) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.type, this.value);
    }

    @java.lang.Override
    public String toString() {
      return "CreatePromptRequest{" + "type: " + type + ", value: " + value + "}";
    }
  }
}
