/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ApiKeySummary.Builder.class
)
public final class ApiKeySummary {
  private final String id;

  private final OffsetDateTime createdAt;

  private final Optional<OffsetDateTime> expiresAt;

  private final Optional<OffsetDateTime> lastUsedAt;

  private final Optional<String> note;

  private final String publicKey;

  private final String displaySecretKey;

  private final Map<String, Object> additionalProperties;

  private ApiKeySummary(String id, OffsetDateTime createdAt, Optional<OffsetDateTime> expiresAt,
      Optional<OffsetDateTime> lastUsedAt, Optional<String> note, String publicKey,
      String displaySecretKey, Map<String, Object> additionalProperties) {
    this.id = id;
    this.createdAt = createdAt;
    this.expiresAt = expiresAt;
    this.lastUsedAt = lastUsedAt;
    this.note = note;
    this.publicKey = publicKey;
    this.displaySecretKey = displaySecretKey;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("expiresAt")
  public Optional<OffsetDateTime> getExpiresAt() {
    return expiresAt;
  }

  @JsonProperty("lastUsedAt")
  public Optional<OffsetDateTime> getLastUsedAt() {
    return lastUsedAt;
  }

  @JsonProperty("note")
  public Optional<String> getNote() {
    return note;
  }

  @JsonProperty("publicKey")
  public String getPublicKey() {
    return publicKey;
  }

  @JsonProperty("displaySecretKey")
  public String getDisplaySecretKey() {
    return displaySecretKey;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ApiKeySummary && equalTo((ApiKeySummary) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ApiKeySummary other) {
    return id.equals(other.id) && createdAt.equals(other.createdAt) && expiresAt.equals(other.expiresAt) && lastUsedAt.equals(other.lastUsedAt) && note.equals(other.note) && publicKey.equals(other.publicKey) && displaySecretKey.equals(other.displaySecretKey);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.createdAt, this.expiresAt, this.lastUsedAt, this.note, this.publicKey, this.displaySecretKey);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    CreatedAtStage id(@NotNull String id);

    Builder from(ApiKeySummary other);
  }

  public interface CreatedAtStage {
    PublicKeyStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface PublicKeyStage {
    DisplaySecretKeyStage publicKey(@NotNull String publicKey);
  }

  public interface DisplaySecretKeyStage {
    _FinalStage displaySecretKey(@NotNull String displaySecretKey);
  }

  public interface _FinalStage {
    ApiKeySummary build();

    _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt);

    _FinalStage expiresAt(OffsetDateTime expiresAt);

    _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt);

    _FinalStage lastUsedAt(OffsetDateTime lastUsedAt);

    _FinalStage note(Optional<String> note);

    _FinalStage note(String note);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, CreatedAtStage, PublicKeyStage, DisplaySecretKeyStage, _FinalStage {
    private String id;

    private OffsetDateTime createdAt;

    private String publicKey;

    private String displaySecretKey;

    private Optional<String> note = Optional.empty();

    private Optional<OffsetDateTime> lastUsedAt = Optional.empty();

    private Optional<OffsetDateTime> expiresAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ApiKeySummary other) {
      id(other.getId());
      createdAt(other.getCreatedAt());
      expiresAt(other.getExpiresAt());
      lastUsedAt(other.getLastUsedAt());
      note(other.getNote());
      publicKey(other.getPublicKey());
      displaySecretKey(other.getDisplaySecretKey());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public CreatedAtStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public PublicKeyStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("publicKey")
    public DisplaySecretKeyStage publicKey(@NotNull String publicKey) {
      this.publicKey = Objects.requireNonNull(publicKey, "publicKey must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("displaySecretKey")
    public _FinalStage displaySecretKey(@NotNull String displaySecretKey) {
      this.displaySecretKey = Objects.requireNonNull(displaySecretKey, "displaySecretKey must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage note(String note) {
      this.note = Optional.ofNullable(note);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "note",
        nulls = Nulls.SKIP
    )
    public _FinalStage note(Optional<String> note) {
      this.note = note;
      return this;
    }

    @java.lang.Override
    public _FinalStage lastUsedAt(OffsetDateTime lastUsedAt) {
      this.lastUsedAt = Optional.ofNullable(lastUsedAt);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "lastUsedAt",
        nulls = Nulls.SKIP
    )
    public _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt) {
      this.lastUsedAt = lastUsedAt;
      return this;
    }

    @java.lang.Override
    public _FinalStage expiresAt(OffsetDateTime expiresAt) {
      this.expiresAt = Optional.ofNullable(expiresAt);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "expiresAt",
        nulls = Nulls.SKIP
    )
    public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
      this.expiresAt = expiresAt;
      return this;
    }

    @java.lang.Override
    public ApiKeySummary build() {
      return new ApiKeySummary(id, createdAt, expiresAt, lastUsedAt, note, publicKey, displaySecretKey, additionalProperties);
    }
  }
}
