/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.projects.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UpdateProjectRequest.Builder.class
)
public final class UpdateProjectRequest {
  private final String name;

  private final Optional<Map<String, Object>> metadata;

  private final int retention;

  private final Map<String, Object> additionalProperties;

  private UpdateProjectRequest(String name, Optional<Map<String, Object>> metadata, int retention,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.metadata = metadata;
    this.retention = retention;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Optional metadata for the project
   */
  @JsonProperty("metadata")
  public Optional<Map<String, Object>> getMetadata() {
    return metadata;
  }

  /**
   * @return Number of days to retain data. Must be 0 or at least 3 days. Requires data-retention entitlement for non-zero values. Optional.
   */
  @JsonProperty("retention")
  public int getRetention() {
    return retention;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UpdateProjectRequest && equalTo((UpdateProjectRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UpdateProjectRequest other) {
    return name.equals(other.name) && metadata.equals(other.metadata) && retention == other.retention;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.metadata, this.retention);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    RetentionStage name(@NotNull String name);

    Builder from(UpdateProjectRequest other);
  }

  public interface RetentionStage {
    _FinalStage retention(int retention);
  }

  public interface _FinalStage {
    UpdateProjectRequest build();

    _FinalStage metadata(Optional<Map<String, Object>> metadata);

    _FinalStage metadata(Map<String, Object> metadata);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, RetentionStage, _FinalStage {
    private String name;

    private int retention;

    private Optional<Map<String, Object>> metadata = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(UpdateProjectRequest other) {
      name(other.getName());
      metadata(other.getMetadata());
      retention(other.getRetention());
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public RetentionStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Number of days to retain data. Must be 0 or at least 3 days. Requires data-retention entitlement for non-zero values. Optional.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("retention")
    public _FinalStage retention(int retention) {
      this.retention = retention;
      return this;
    }

    /**
     * <p>Optional metadata for the project</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(Map<String, Object> metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Map<String, Object>> metadata) {
      this.metadata = metadata;
      return this;
    }

    @java.lang.Override
    public UpdateProjectRequest build() {
      return new UpdateProjectRequest(name, metadata, retention, additionalProperties);
    }
  }
}
