/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = MembershipsResponse.Builder.class
)
public final class MembershipsResponse {
  private final List<MembershipResponse> memberships;

  private final Map<String, Object> additionalProperties;

  private MembershipsResponse(List<MembershipResponse> memberships,
      Map<String, Object> additionalProperties) {
    this.memberships = memberships;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("memberships")
  public List<MembershipResponse> getMemberships() {
    return memberships;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MembershipsResponse && equalTo((MembershipsResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(MembershipsResponse other) {
    return memberships.equals(other.memberships);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.memberships);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<MembershipResponse> memberships = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(MembershipsResponse other) {
      memberships(other.getMemberships());
      return this;
    }

    @JsonSetter(
        value = "memberships",
        nulls = Nulls.SKIP
    )
    public Builder memberships(List<MembershipResponse> memberships) {
      this.memberships.clear();
      this.memberships.addAll(memberships);
      return this;
    }

    public Builder addMemberships(MembershipResponse memberships) {
      this.memberships.add(memberships);
      return this;
    }

    public Builder addAllMemberships(List<MembershipResponse> memberships) {
      this.memberships.addAll(memberships);
      return this;
    }

    public MembershipsResponse build() {
      return new MembershipsResponse(memberships, additionalProperties);
    }
  }
}
