/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = MembershipRequest.Builder.class
)
public final class MembershipRequest {
  private final String userId;

  private final MembershipRole role;

  private final Map<String, Object> additionalProperties;

  private MembershipRequest(String userId, MembershipRole role,
      Map<String, Object> additionalProperties) {
    this.userId = userId;
    this.role = role;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("userId")
  public String getUserId() {
    return userId;
  }

  @JsonProperty("role")
  public MembershipRole getRole() {
    return role;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MembershipRequest && equalTo((MembershipRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(MembershipRequest other) {
    return userId.equals(other.userId) && role.equals(other.role);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.userId, this.role);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static UserIdStage builder() {
    return new Builder();
  }

  public interface UserIdStage {
    RoleStage userId(@NotNull String userId);

    Builder from(MembershipRequest other);
  }

  public interface RoleStage {
    _FinalStage role(@NotNull MembershipRole role);
  }

  public interface _FinalStage {
    MembershipRequest build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements UserIdStage, RoleStage, _FinalStage {
    private String userId;

    private MembershipRole role;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(MembershipRequest other) {
      userId(other.getUserId());
      role(other.getRole());
      return this;
    }

    @java.lang.Override
    @JsonSetter("userId")
    public RoleStage userId(@NotNull String userId) {
      this.userId = Objects.requireNonNull(userId, "userId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("role")
    public _FinalStage role(@NotNull MembershipRole role) {
      this.role = Objects.requireNonNull(role, "role must not be null");
      return this;
    }

    @java.lang.Override
    public MembershipRequest build() {
      return new MembershipRequest(userId, role, additionalProperties);
    }
  }
}
