/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import com.langfuse.client.resources.commons.types.ObservationLevel;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = OptionalObservationBody.Builder.class
)
public final class OptionalObservationBody implements IOptionalObservationBody {
  private final Optional<String> traceId;

  private final Optional<String> name;

  private final Optional<OffsetDateTime> startTime;

  private final Optional<Object> metadata;

  private final Optional<Object> input;

  private final Optional<Object> output;

  private final Optional<ObservationLevel> level;

  private final Optional<String> statusMessage;

  private final Optional<String> parentObservationId;

  private final Optional<String> version;

  private final Optional<String> environment;

  private final Map<String, Object> additionalProperties;

  private OptionalObservationBody(Optional<String> traceId, Optional<String> name,
      Optional<OffsetDateTime> startTime, Optional<Object> metadata, Optional<Object> input,
      Optional<Object> output, Optional<ObservationLevel> level, Optional<String> statusMessage,
      Optional<String> parentObservationId, Optional<String> version, Optional<String> environment,
      Map<String, Object> additionalProperties) {
    this.traceId = traceId;
    this.name = name;
    this.startTime = startTime;
    this.metadata = metadata;
    this.input = input;
    this.output = output;
    this.level = level;
    this.statusMessage = statusMessage;
    this.parentObservationId = parentObservationId;
    this.version = version;
    this.environment = environment;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("traceId")
  @java.lang.Override
  public Optional<String> getTraceId() {
    return traceId;
  }

  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("startTime")
  @java.lang.Override
  public Optional<OffsetDateTime> getStartTime() {
    return startTime;
  }

  @JsonProperty("metadata")
  @java.lang.Override
  public Optional<Object> getMetadata() {
    return metadata;
  }

  @JsonProperty("input")
  @java.lang.Override
  public Optional<Object> getInput() {
    return input;
  }

  @JsonProperty("output")
  @java.lang.Override
  public Optional<Object> getOutput() {
    return output;
  }

  @JsonProperty("level")
  @java.lang.Override
  public Optional<ObservationLevel> getLevel() {
    return level;
  }

  @JsonProperty("statusMessage")
  @java.lang.Override
  public Optional<String> getStatusMessage() {
    return statusMessage;
  }

  @JsonProperty("parentObservationId")
  @java.lang.Override
  public Optional<String> getParentObservationId() {
    return parentObservationId;
  }

  @JsonProperty("version")
  @java.lang.Override
  public Optional<String> getVersion() {
    return version;
  }

  @JsonProperty("environment")
  @java.lang.Override
  public Optional<String> getEnvironment() {
    return environment;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof OptionalObservationBody && equalTo((OptionalObservationBody) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(OptionalObservationBody other) {
    return traceId.equals(other.traceId) && name.equals(other.name) && startTime.equals(other.startTime) && metadata.equals(other.metadata) && input.equals(other.input) && output.equals(other.output) && level.equals(other.level) && statusMessage.equals(other.statusMessage) && parentObservationId.equals(other.parentObservationId) && version.equals(other.version) && environment.equals(other.environment);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.traceId, this.name, this.startTime, this.metadata, this.input, this.output, this.level, this.statusMessage, this.parentObservationId, this.version, this.environment);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> traceId = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<OffsetDateTime> startTime = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<Object> input = Optional.empty();

    private Optional<Object> output = Optional.empty();

    private Optional<ObservationLevel> level = Optional.empty();

    private Optional<String> statusMessage = Optional.empty();

    private Optional<String> parentObservationId = Optional.empty();

    private Optional<String> version = Optional.empty();

    private Optional<String> environment = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(OptionalObservationBody other) {
      traceId(other.getTraceId());
      name(other.getName());
      startTime(other.getStartTime());
      metadata(other.getMetadata());
      input(other.getInput());
      output(other.getOutput());
      level(other.getLevel());
      statusMessage(other.getStatusMessage());
      parentObservationId(other.getParentObservationId());
      version(other.getVersion());
      environment(other.getEnvironment());
      return this;
    }

    @JsonSetter(
        value = "traceId",
        nulls = Nulls.SKIP
    )
    public Builder traceId(Optional<String> traceId) {
      this.traceId = traceId;
      return this;
    }

    public Builder traceId(String traceId) {
      this.traceId = Optional.ofNullable(traceId);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "startTime",
        nulls = Nulls.SKIP
    )
    public Builder startTime(Optional<OffsetDateTime> startTime) {
      this.startTime = startTime;
      return this;
    }

    public Builder startTime(OffsetDateTime startTime) {
      this.startTime = Optional.ofNullable(startTime);
      return this;
    }

    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public Builder metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    public Builder metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @JsonSetter(
        value = "input",
        nulls = Nulls.SKIP
    )
    public Builder input(Optional<Object> input) {
      this.input = input;
      return this;
    }

    public Builder input(Object input) {
      this.input = Optional.ofNullable(input);
      return this;
    }

    @JsonSetter(
        value = "output",
        nulls = Nulls.SKIP
    )
    public Builder output(Optional<Object> output) {
      this.output = output;
      return this;
    }

    public Builder output(Object output) {
      this.output = Optional.ofNullable(output);
      return this;
    }

    @JsonSetter(
        value = "level",
        nulls = Nulls.SKIP
    )
    public Builder level(Optional<ObservationLevel> level) {
      this.level = level;
      return this;
    }

    public Builder level(ObservationLevel level) {
      this.level = Optional.ofNullable(level);
      return this;
    }

    @JsonSetter(
        value = "statusMessage",
        nulls = Nulls.SKIP
    )
    public Builder statusMessage(Optional<String> statusMessage) {
      this.statusMessage = statusMessage;
      return this;
    }

    public Builder statusMessage(String statusMessage) {
      this.statusMessage = Optional.ofNullable(statusMessage);
      return this;
    }

    @JsonSetter(
        value = "parentObservationId",
        nulls = Nulls.SKIP
    )
    public Builder parentObservationId(Optional<String> parentObservationId) {
      this.parentObservationId = parentObservationId;
      return this;
    }

    public Builder parentObservationId(String parentObservationId) {
      this.parentObservationId = Optional.ofNullable(parentObservationId);
      return this;
    }

    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public Builder version(Optional<String> version) {
      this.version = version;
      return this;
    }

    public Builder version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public Builder environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    public Builder environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    public OptionalObservationBody build() {
      return new OptionalObservationBody(traceId, name, startTime, metadata, input, output, level, statusMessage, parentObservationId, version, environment, additionalProperties);
    }
  }
}
