/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = OpenAiResponseUsageSchema.Builder.class
)
public final class OpenAiResponseUsageSchema {
  private final int inputTokens;

  private final int outputTokens;

  private final int totalTokens;

  private final Optional<Map<String, Optional<Integer>>> inputTokensDetails;

  private final Optional<Map<String, Optional<Integer>>> outputTokensDetails;

  private final Map<String, Object> additionalProperties;

  private OpenAiResponseUsageSchema(int inputTokens, int outputTokens, int totalTokens,
      Optional<Map<String, Optional<Integer>>> inputTokensDetails,
      Optional<Map<String, Optional<Integer>>> outputTokensDetails,
      Map<String, Object> additionalProperties) {
    this.inputTokens = inputTokens;
    this.outputTokens = outputTokens;
    this.totalTokens = totalTokens;
    this.inputTokensDetails = inputTokensDetails;
    this.outputTokensDetails = outputTokensDetails;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("input_tokens")
  public int getInputTokens() {
    return inputTokens;
  }

  @JsonProperty("output_tokens")
  public int getOutputTokens() {
    return outputTokens;
  }

  @JsonProperty("total_tokens")
  public int getTotalTokens() {
    return totalTokens;
  }

  @JsonProperty("input_tokens_details")
  public Optional<Map<String, Optional<Integer>>> getInputTokensDetails() {
    return inputTokensDetails;
  }

  @JsonProperty("output_tokens_details")
  public Optional<Map<String, Optional<Integer>>> getOutputTokensDetails() {
    return outputTokensDetails;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof OpenAiResponseUsageSchema && equalTo((OpenAiResponseUsageSchema) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(OpenAiResponseUsageSchema other) {
    return inputTokens == other.inputTokens && outputTokens == other.outputTokens && totalTokens == other.totalTokens && inputTokensDetails.equals(other.inputTokensDetails) && outputTokensDetails.equals(other.outputTokensDetails);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.inputTokens, this.outputTokens, this.totalTokens, this.inputTokensDetails, this.outputTokensDetails);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static InputTokensStage builder() {
    return new Builder();
  }

  public interface InputTokensStage {
    OutputTokensStage inputTokens(int inputTokens);

    Builder from(OpenAiResponseUsageSchema other);
  }

  public interface OutputTokensStage {
    TotalTokensStage outputTokens(int outputTokens);
  }

  public interface TotalTokensStage {
    _FinalStage totalTokens(int totalTokens);
  }

  public interface _FinalStage {
    OpenAiResponseUsageSchema build();

    _FinalStage inputTokensDetails(Optional<Map<String, Optional<Integer>>> inputTokensDetails);

    _FinalStage inputTokensDetails(Map<String, Optional<Integer>> inputTokensDetails);

    _FinalStage outputTokensDetails(Optional<Map<String, Optional<Integer>>> outputTokensDetails);

    _FinalStage outputTokensDetails(Map<String, Optional<Integer>> outputTokensDetails);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements InputTokensStage, OutputTokensStage, TotalTokensStage, _FinalStage {
    private int inputTokens;

    private int outputTokens;

    private int totalTokens;

    private Optional<Map<String, Optional<Integer>>> outputTokensDetails = Optional.empty();

    private Optional<Map<String, Optional<Integer>>> inputTokensDetails = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(OpenAiResponseUsageSchema other) {
      inputTokens(other.getInputTokens());
      outputTokens(other.getOutputTokens());
      totalTokens(other.getTotalTokens());
      inputTokensDetails(other.getInputTokensDetails());
      outputTokensDetails(other.getOutputTokensDetails());
      return this;
    }

    @java.lang.Override
    @JsonSetter("input_tokens")
    public OutputTokensStage inputTokens(int inputTokens) {
      this.inputTokens = inputTokens;
      return this;
    }

    @java.lang.Override
    @JsonSetter("output_tokens")
    public TotalTokensStage outputTokens(int outputTokens) {
      this.outputTokens = outputTokens;
      return this;
    }

    @java.lang.Override
    @JsonSetter("total_tokens")
    public _FinalStage totalTokens(int totalTokens) {
      this.totalTokens = totalTokens;
      return this;
    }

    @java.lang.Override
    public _FinalStage outputTokensDetails(Map<String, Optional<Integer>> outputTokensDetails) {
      this.outputTokensDetails = Optional.ofNullable(outputTokensDetails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "output_tokens_details",
        nulls = Nulls.SKIP
    )
    public _FinalStage outputTokensDetails(
        Optional<Map<String, Optional<Integer>>> outputTokensDetails) {
      this.outputTokensDetails = outputTokensDetails;
      return this;
    }

    @java.lang.Override
    public _FinalStage inputTokensDetails(Map<String, Optional<Integer>> inputTokensDetails) {
      this.inputTokensDetails = Optional.ofNullable(inputTokensDetails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "input_tokens_details",
        nulls = Nulls.SKIP
    )
    public _FinalStage inputTokensDetails(
        Optional<Map<String, Optional<Integer>>> inputTokensDetails) {
      this.inputTokensDetails = inputTokensDetails;
      return this;
    }

    @java.lang.Override
    public OpenAiResponseUsageSchema build() {
      return new OpenAiResponseUsageSchema(inputTokens, outputTokens, totalTokens, inputTokensDetails, outputTokensDetails, additionalProperties);
    }
  }
}
