/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import com.langfuse.client.resources.commons.types.MapValue;
import com.langfuse.client.resources.commons.types.ObservationLevel;
import com.langfuse.client.resources.commons.types.Usage;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ObservationBody.Builder.class
)
public final class ObservationBody {
  private final Optional<String> id;

  private final Optional<String> traceId;

  private final ObservationType type;

  private final Optional<String> name;

  private final Optional<OffsetDateTime> startTime;

  private final Optional<OffsetDateTime> endTime;

  private final Optional<OffsetDateTime> completionStartTime;

  private final Optional<String> model;

  private final Optional<Map<String, MapValue>> modelParameters;

  private final Optional<Object> input;

  private final Optional<String> version;

  private final Optional<Object> metadata;

  private final Optional<Object> output;

  private final Optional<Usage> usage;

  private final Optional<ObservationLevel> level;

  private final Optional<String> statusMessage;

  private final Optional<String> parentObservationId;

  private final Optional<String> environment;

  private final Map<String, Object> additionalProperties;

  private ObservationBody(Optional<String> id, Optional<String> traceId, ObservationType type,
      Optional<String> name, Optional<OffsetDateTime> startTime, Optional<OffsetDateTime> endTime,
      Optional<OffsetDateTime> completionStartTime, Optional<String> model,
      Optional<Map<String, MapValue>> modelParameters, Optional<Object> input,
      Optional<String> version, Optional<Object> metadata, Optional<Object> output,
      Optional<Usage> usage, Optional<ObservationLevel> level, Optional<String> statusMessage,
      Optional<String> parentObservationId, Optional<String> environment,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.traceId = traceId;
    this.type = type;
    this.name = name;
    this.startTime = startTime;
    this.endTime = endTime;
    this.completionStartTime = completionStartTime;
    this.model = model;
    this.modelParameters = modelParameters;
    this.input = input;
    this.version = version;
    this.metadata = metadata;
    this.output = output;
    this.usage = usage;
    this.level = level;
    this.statusMessage = statusMessage;
    this.parentObservationId = parentObservationId;
    this.environment = environment;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  @JsonProperty("traceId")
  public Optional<String> getTraceId() {
    return traceId;
  }

  @JsonProperty("type")
  public ObservationType getType() {
    return type;
  }

  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("startTime")
  public Optional<OffsetDateTime> getStartTime() {
    return startTime;
  }

  @JsonProperty("endTime")
  public Optional<OffsetDateTime> getEndTime() {
    return endTime;
  }

  @JsonProperty("completionStartTime")
  public Optional<OffsetDateTime> getCompletionStartTime() {
    return completionStartTime;
  }

  @JsonProperty("model")
  public Optional<String> getModel() {
    return model;
  }

  @JsonProperty("modelParameters")
  public Optional<Map<String, MapValue>> getModelParameters() {
    return modelParameters;
  }

  @JsonProperty("input")
  public Optional<Object> getInput() {
    return input;
  }

  @JsonProperty("version")
  public Optional<String> getVersion() {
    return version;
  }

  @JsonProperty("metadata")
  public Optional<Object> getMetadata() {
    return metadata;
  }

  @JsonProperty("output")
  public Optional<Object> getOutput() {
    return output;
  }

  @JsonProperty("usage")
  public Optional<Usage> getUsage() {
    return usage;
  }

  @JsonProperty("level")
  public Optional<ObservationLevel> getLevel() {
    return level;
  }

  @JsonProperty("statusMessage")
  public Optional<String> getStatusMessage() {
    return statusMessage;
  }

  @JsonProperty("parentObservationId")
  public Optional<String> getParentObservationId() {
    return parentObservationId;
  }

  @JsonProperty("environment")
  public Optional<String> getEnvironment() {
    return environment;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ObservationBody && equalTo((ObservationBody) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ObservationBody other) {
    return id.equals(other.id) && traceId.equals(other.traceId) && type.equals(other.type) && name.equals(other.name) && startTime.equals(other.startTime) && endTime.equals(other.endTime) && completionStartTime.equals(other.completionStartTime) && model.equals(other.model) && modelParameters.equals(other.modelParameters) && input.equals(other.input) && version.equals(other.version) && metadata.equals(other.metadata) && output.equals(other.output) && usage.equals(other.usage) && level.equals(other.level) && statusMessage.equals(other.statusMessage) && parentObservationId.equals(other.parentObservationId) && environment.equals(other.environment);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.environment);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TypeStage builder() {
    return new Builder();
  }

  public interface TypeStage {
    _FinalStage type(@NotNull ObservationType type);

    Builder from(ObservationBody other);
  }

  public interface _FinalStage {
    ObservationBody build();

    _FinalStage id(Optional<String> id);

    _FinalStage id(String id);

    _FinalStage traceId(Optional<String> traceId);

    _FinalStage traceId(String traceId);

    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    _FinalStage startTime(Optional<OffsetDateTime> startTime);

    _FinalStage startTime(OffsetDateTime startTime);

    _FinalStage endTime(Optional<OffsetDateTime> endTime);

    _FinalStage endTime(OffsetDateTime endTime);

    _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime);

    _FinalStage completionStartTime(OffsetDateTime completionStartTime);

    _FinalStage model(Optional<String> model);

    _FinalStage model(String model);

    _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters);

    _FinalStage modelParameters(Map<String, MapValue> modelParameters);

    _FinalStage input(Optional<Object> input);

    _FinalStage input(Object input);

    _FinalStage version(Optional<String> version);

    _FinalStage version(String version);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage output(Optional<Object> output);

    _FinalStage output(Object output);

    _FinalStage usage(Optional<Usage> usage);

    _FinalStage usage(Usage usage);

    _FinalStage level(Optional<ObservationLevel> level);

    _FinalStage level(ObservationLevel level);

    _FinalStage statusMessage(Optional<String> statusMessage);

    _FinalStage statusMessage(String statusMessage);

    _FinalStage parentObservationId(Optional<String> parentObservationId);

    _FinalStage parentObservationId(String parentObservationId);

    _FinalStage environment(Optional<String> environment);

    _FinalStage environment(String environment);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TypeStage, _FinalStage {
    private ObservationType type;

    private Optional<String> environment = Optional.empty();

    private Optional<String> parentObservationId = Optional.empty();

    private Optional<String> statusMessage = Optional.empty();

    private Optional<ObservationLevel> level = Optional.empty();

    private Optional<Usage> usage = Optional.empty();

    private Optional<Object> output = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> version = Optional.empty();

    private Optional<Object> input = Optional.empty();

    private Optional<Map<String, MapValue>> modelParameters = Optional.empty();

    private Optional<String> model = Optional.empty();

    private Optional<OffsetDateTime> completionStartTime = Optional.empty();

    private Optional<OffsetDateTime> endTime = Optional.empty();

    private Optional<OffsetDateTime> startTime = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> traceId = Optional.empty();

    private Optional<String> id = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ObservationBody other) {
      id(other.getId());
      traceId(other.getTraceId());
      type(other.getType());
      name(other.getName());
      startTime(other.getStartTime());
      endTime(other.getEndTime());
      completionStartTime(other.getCompletionStartTime());
      model(other.getModel());
      modelParameters(other.getModelParameters());
      input(other.getInput());
      version(other.getVersion());
      metadata(other.getMetadata());
      output(other.getOutput());
      usage(other.getUsage());
      level(other.getLevel());
      statusMessage(other.getStatusMessage());
      parentObservationId(other.getParentObservationId());
      environment(other.getEnvironment());
      return this;
    }

    @java.lang.Override
    @JsonSetter("type")
    public _FinalStage type(@NotNull ObservationType type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public _FinalStage environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    @java.lang.Override
    public _FinalStage parentObservationId(String parentObservationId) {
      this.parentObservationId = Optional.ofNullable(parentObservationId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "parentObservationId",
        nulls = Nulls.SKIP
    )
    public _FinalStage parentObservationId(Optional<String> parentObservationId) {
      this.parentObservationId = parentObservationId;
      return this;
    }

    @java.lang.Override
    public _FinalStage statusMessage(String statusMessage) {
      this.statusMessage = Optional.ofNullable(statusMessage);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "statusMessage",
        nulls = Nulls.SKIP
    )
    public _FinalStage statusMessage(Optional<String> statusMessage) {
      this.statusMessage = statusMessage;
      return this;
    }

    @java.lang.Override
    public _FinalStage level(ObservationLevel level) {
      this.level = Optional.ofNullable(level);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "level",
        nulls = Nulls.SKIP
    )
    public _FinalStage level(Optional<ObservationLevel> level) {
      this.level = level;
      return this;
    }

    @java.lang.Override
    public _FinalStage usage(Usage usage) {
      this.usage = Optional.ofNullable(usage);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "usage",
        nulls = Nulls.SKIP
    )
    public _FinalStage usage(Optional<Usage> usage) {
      this.usage = usage;
      return this;
    }

    @java.lang.Override
    public _FinalStage output(Object output) {
      this.output = Optional.ofNullable(output);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "output",
        nulls = Nulls.SKIP
    )
    public _FinalStage output(Optional<Object> output) {
      this.output = output;
      return this;
    }

    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    @java.lang.Override
    public _FinalStage version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public _FinalStage version(Optional<String> version) {
      this.version = version;
      return this;
    }

    @java.lang.Override
    public _FinalStage input(Object input) {
      this.input = Optional.ofNullable(input);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "input",
        nulls = Nulls.SKIP
    )
    public _FinalStage input(Optional<Object> input) {
      this.input = input;
      return this;
    }

    @java.lang.Override
    public _FinalStage modelParameters(Map<String, MapValue> modelParameters) {
      this.modelParameters = Optional.ofNullable(modelParameters);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "modelParameters",
        nulls = Nulls.SKIP
    )
    public _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters) {
      this.modelParameters = modelParameters;
      return this;
    }

    @java.lang.Override
    public _FinalStage model(String model) {
      this.model = Optional.ofNullable(model);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "model",
        nulls = Nulls.SKIP
    )
    public _FinalStage model(Optional<String> model) {
      this.model = model;
      return this;
    }

    @java.lang.Override
    public _FinalStage completionStartTime(OffsetDateTime completionStartTime) {
      this.completionStartTime = Optional.ofNullable(completionStartTime);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "completionStartTime",
        nulls = Nulls.SKIP
    )
    public _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime) {
      this.completionStartTime = completionStartTime;
      return this;
    }

    @java.lang.Override
    public _FinalStage endTime(OffsetDateTime endTime) {
      this.endTime = Optional.ofNullable(endTime);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "endTime",
        nulls = Nulls.SKIP
    )
    public _FinalStage endTime(Optional<OffsetDateTime> endTime) {
      this.endTime = endTime;
      return this;
    }

    @java.lang.Override
    public _FinalStage startTime(OffsetDateTime startTime) {
      this.startTime = Optional.ofNullable(startTime);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "startTime",
        nulls = Nulls.SKIP
    )
    public _FinalStage startTime(Optional<OffsetDateTime> startTime) {
      this.startTime = startTime;
      return this;
    }

    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    @java.lang.Override
    public _FinalStage traceId(String traceId) {
      this.traceId = Optional.ofNullable(traceId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "traceId",
        nulls = Nulls.SKIP
    )
    public _FinalStage traceId(Optional<String> traceId) {
      this.traceId = traceId;
      return this;
    }

    @java.lang.Override
    public _FinalStage id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public _FinalStage id(Optional<String> id) {
      this.id = id;
      return this;
    }

    @java.lang.Override
    public ObservationBody build() {
      return new ObservationBody(id, traceId, type, name, startTime, endTime, completionStartTime, model, modelParameters, input, version, metadata, output, usage, level, statusMessage, parentObservationId, environment, additionalProperties);
    }
  }
}
