/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.health.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = HealthResponse.Builder.class
)
public final class HealthResponse {
  private final String version;

  private final String status;

  private final Map<String, Object> additionalProperties;

  private HealthResponse(String version, String status, Map<String, Object> additionalProperties) {
    this.version = version;
    this.status = status;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Langfuse server version
   */
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  @JsonProperty("status")
  public String getStatus() {
    return status;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof HealthResponse && equalTo((HealthResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(HealthResponse other) {
    return version.equals(other.version) && status.equals(other.status);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.version, this.status);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static VersionStage builder() {
    return new Builder();
  }

  public interface VersionStage {
    StatusStage version(@NotNull String version);

    Builder from(HealthResponse other);
  }

  public interface StatusStage {
    _FinalStage status(@NotNull String status);
  }

  public interface _FinalStage {
    HealthResponse build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements VersionStage, StatusStage, _FinalStage {
    private String version;

    private String status;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(HealthResponse other) {
      version(other.getVersion());
      status(other.getStatus());
      return this;
    }

    /**
     * <p>Langfuse server version</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("version")
    public StatusStage version(@NotNull String version) {
      this.version = Objects.requireNonNull(version, "version must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("status")
    public _FinalStage status(@NotNull String status) {
      this.status = Objects.requireNonNull(status, "status must not be null");
      return this;
    }

    @java.lang.Override
    public HealthResponse build() {
      return new HealthResponse(version, status, additionalProperties);
    }
  }
}
