/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.datasets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateDatasetRequest.Builder.class
)
public final class CreateDatasetRequest {
  private final String name;

  private final Optional<String> description;

  private final Optional<Object> metadata;

  private final Map<String, Object> additionalProperties;

  private CreateDatasetRequest(String name, Optional<String> description, Optional<Object> metadata,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.description = description;
    this.metadata = metadata;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @JsonProperty("metadata")
  public Optional<Object> getMetadata() {
    return metadata;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateDatasetRequest && equalTo((CreateDatasetRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateDatasetRequest other) {
    return name.equals(other.name) && description.equals(other.description) && metadata.equals(other.metadata);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.description, this.metadata);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    _FinalStage name(@NotNull String name);

    Builder from(CreateDatasetRequest other);
  }

  public interface _FinalStage {
    CreateDatasetRequest build();

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, _FinalStage {
    private String name;

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> description = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateDatasetRequest other) {
      name(other.getName());
      description(other.getDescription());
      metadata(other.getMetadata());
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    @java.lang.Override
    public CreateDatasetRequest build() {
      return new CreateDatasetRequest(name, description, metadata, additionalProperties);
    }
  }
}
