/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.datasets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetDatasetRunsRequest.Builder.class
)
public final class GetDatasetRunsRequest {
  private final Optional<Integer> page;

  private final Optional<Integer> limit;

  private final Map<String, Object> additionalProperties;

  private GetDatasetRunsRequest(Optional<Integer> page, Optional<Integer> limit,
      Map<String, Object> additionalProperties) {
    this.page = page;
    this.limit = limit;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return page number, starts at 1
   */
  @JsonProperty("page")
  public Optional<Integer> getPage() {
    return page;
  }

  /**
   * @return limit of items per page
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetDatasetRunsRequest && equalTo((GetDatasetRunsRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetDatasetRunsRequest other) {
    return page.equals(other.page) && limit.equals(other.limit);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.page, this.limit);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> page = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(GetDatasetRunsRequest other) {
      page(other.getPage());
      limit(other.getLimit());
      return this;
    }

    @JsonSetter(
        value = "page",
        nulls = Nulls.SKIP
    )
    public Builder page(Optional<Integer> page) {
      this.page = page;
      return this;
    }

    public Builder page(Integer page) {
      this.page = Optional.ofNullable(page);
      return this;
    }

    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    public GetDatasetRunsRequest build() {
      return new GetDatasetRunsRequest(page, limit, additionalProperties);
    }
  }
}
