/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.datasetrunitems.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateDatasetRunItemRequest.Builder.class
)
public final class CreateDatasetRunItemRequest {
  private final String runName;

  private final Optional<String> runDescription;

  private final Optional<Object> metadata;

  private final String datasetItemId;

  private final Optional<String> observationId;

  private final Optional<String> traceId;

  private final Map<String, Object> additionalProperties;

  private CreateDatasetRunItemRequest(String runName, Optional<String> runDescription,
      Optional<Object> metadata, String datasetItemId, Optional<String> observationId,
      Optional<String> traceId, Map<String, Object> additionalProperties) {
    this.runName = runName;
    this.runDescription = runDescription;
    this.metadata = metadata;
    this.datasetItemId = datasetItemId;
    this.observationId = observationId;
    this.traceId = traceId;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("runName")
  public String getRunName() {
    return runName;
  }

  /**
   * @return Description of the run. If run exists, description will be updated.
   */
  @JsonProperty("runDescription")
  public Optional<String> getRunDescription() {
    return runDescription;
  }

  /**
   * @return Metadata of the dataset run, updates run if run already exists
   */
  @JsonProperty("metadata")
  public Optional<Object> getMetadata() {
    return metadata;
  }

  @JsonProperty("datasetItemId")
  public String getDatasetItemId() {
    return datasetItemId;
  }

  @JsonProperty("observationId")
  public Optional<String> getObservationId() {
    return observationId;
  }

  /**
   * @return traceId should always be provided. For compatibility with older SDK versions it can also be inferred from the provided observationId.
   */
  @JsonProperty("traceId")
  public Optional<String> getTraceId() {
    return traceId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateDatasetRunItemRequest && equalTo((CreateDatasetRunItemRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateDatasetRunItemRequest other) {
    return runName.equals(other.runName) && runDescription.equals(other.runDescription) && metadata.equals(other.metadata) && datasetItemId.equals(other.datasetItemId) && observationId.equals(other.observationId) && traceId.equals(other.traceId);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.runName, this.runDescription, this.metadata, this.datasetItemId, this.observationId, this.traceId);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static RunNameStage builder() {
    return new Builder();
  }

  public interface RunNameStage {
    DatasetItemIdStage runName(@NotNull String runName);

    Builder from(CreateDatasetRunItemRequest other);
  }

  public interface DatasetItemIdStage {
    _FinalStage datasetItemId(@NotNull String datasetItemId);
  }

  public interface _FinalStage {
    CreateDatasetRunItemRequest build();

    _FinalStage runDescription(Optional<String> runDescription);

    _FinalStage runDescription(String runDescription);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage observationId(Optional<String> observationId);

    _FinalStage observationId(String observationId);

    _FinalStage traceId(Optional<String> traceId);

    _FinalStage traceId(String traceId);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements RunNameStage, DatasetItemIdStage, _FinalStage {
    private String runName;

    private String datasetItemId;

    private Optional<String> traceId = Optional.empty();

    private Optional<String> observationId = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> runDescription = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateDatasetRunItemRequest other) {
      runName(other.getRunName());
      runDescription(other.getRunDescription());
      metadata(other.getMetadata());
      datasetItemId(other.getDatasetItemId());
      observationId(other.getObservationId());
      traceId(other.getTraceId());
      return this;
    }

    @java.lang.Override
    @JsonSetter("runName")
    public DatasetItemIdStage runName(@NotNull String runName) {
      this.runName = Objects.requireNonNull(runName, "runName must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("datasetItemId")
    public _FinalStage datasetItemId(@NotNull String datasetItemId) {
      this.datasetItemId = Objects.requireNonNull(datasetItemId, "datasetItemId must not be null");
      return this;
    }

    /**
     * <p>traceId should always be provided. For compatibility with older SDK versions it can also be inferred from the provided observationId.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage traceId(String traceId) {
      this.traceId = Optional.ofNullable(traceId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "traceId",
        nulls = Nulls.SKIP
    )
    public _FinalStage traceId(Optional<String> traceId) {
      this.traceId = traceId;
      return this;
    }

    @java.lang.Override
    public _FinalStage observationId(String observationId) {
      this.observationId = Optional.ofNullable(observationId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "observationId",
        nulls = Nulls.SKIP
    )
    public _FinalStage observationId(Optional<String> observationId) {
      this.observationId = observationId;
      return this;
    }

    /**
     * <p>Metadata of the dataset run, updates run if run already exists</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * <p>Description of the run. If run exists, description will be updated.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage runDescription(String runDescription) {
      this.runDescription = Optional.ofNullable(runDescription);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "runDescription",
        nulls = Nulls.SKIP
    )
    public _FinalStage runDescription(Optional<String> runDescription) {
      this.runDescription = runDescription;
      return this;
    }

    @java.lang.Override
    public CreateDatasetRunItemRequest build() {
      return new CreateDatasetRunItemRequest(runName, runDescription, metadata, datasetItemId, observationId, traceId, additionalProperties);
    }
  }
}
