/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Usage.Builder.class
)
public final class Usage {
  private final Optional<Integer> input;

  private final Optional<Integer> output;

  private final Optional<Integer> total;

  private final Optional<ModelUsageUnit> unit;

  private final Optional<Double> inputCost;

  private final Optional<Double> outputCost;

  private final Optional<Double> totalCost;

  private final Map<String, Object> additionalProperties;

  private Usage(Optional<Integer> input, Optional<Integer> output, Optional<Integer> total,
      Optional<ModelUsageUnit> unit, Optional<Double> inputCost, Optional<Double> outputCost,
      Optional<Double> totalCost, Map<String, Object> additionalProperties) {
    this.input = input;
    this.output = output;
    this.total = total;
    this.unit = unit;
    this.inputCost = inputCost;
    this.outputCost = outputCost;
    this.totalCost = totalCost;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Number of input units (e.g. tokens)
   */
  @JsonProperty("input")
  public Optional<Integer> getInput() {
    return input;
  }

  /**
   * @return Number of output units (e.g. tokens)
   */
  @JsonProperty("output")
  public Optional<Integer> getOutput() {
    return output;
  }

  /**
   * @return Defaults to input+output if not set
   */
  @JsonProperty("total")
  public Optional<Integer> getTotal() {
    return total;
  }

  @JsonProperty("unit")
  public Optional<ModelUsageUnit> getUnit() {
    return unit;
  }

  /**
   * @return USD input cost
   */
  @JsonProperty("inputCost")
  public Optional<Double> getInputCost() {
    return inputCost;
  }

  /**
   * @return USD output cost
   */
  @JsonProperty("outputCost")
  public Optional<Double> getOutputCost() {
    return outputCost;
  }

  /**
   * @return USD total cost, defaults to input+output
   */
  @JsonProperty("totalCost")
  public Optional<Double> getTotalCost() {
    return totalCost;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Usage && equalTo((Usage) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Usage other) {
    return input.equals(other.input) && output.equals(other.output) && total.equals(other.total) && unit.equals(other.unit) && inputCost.equals(other.inputCost) && outputCost.equals(other.outputCost) && totalCost.equals(other.totalCost);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.input, this.output, this.total, this.unit, this.inputCost, this.outputCost, this.totalCost);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> input = Optional.empty();

    private Optional<Integer> output = Optional.empty();

    private Optional<Integer> total = Optional.empty();

    private Optional<ModelUsageUnit> unit = Optional.empty();

    private Optional<Double> inputCost = Optional.empty();

    private Optional<Double> outputCost = Optional.empty();

    private Optional<Double> totalCost = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(Usage other) {
      input(other.getInput());
      output(other.getOutput());
      total(other.getTotal());
      unit(other.getUnit());
      inputCost(other.getInputCost());
      outputCost(other.getOutputCost());
      totalCost(other.getTotalCost());
      return this;
    }

    @JsonSetter(
        value = "input",
        nulls = Nulls.SKIP
    )
    public Builder input(Optional<Integer> input) {
      this.input = input;
      return this;
    }

    public Builder input(Integer input) {
      this.input = Optional.ofNullable(input);
      return this;
    }

    @JsonSetter(
        value = "output",
        nulls = Nulls.SKIP
    )
    public Builder output(Optional<Integer> output) {
      this.output = output;
      return this;
    }

    public Builder output(Integer output) {
      this.output = Optional.ofNullable(output);
      return this;
    }

    @JsonSetter(
        value = "total",
        nulls = Nulls.SKIP
    )
    public Builder total(Optional<Integer> total) {
      this.total = total;
      return this;
    }

    public Builder total(Integer total) {
      this.total = Optional.ofNullable(total);
      return this;
    }

    @JsonSetter(
        value = "unit",
        nulls = Nulls.SKIP
    )
    public Builder unit(Optional<ModelUsageUnit> unit) {
      this.unit = unit;
      return this;
    }

    public Builder unit(ModelUsageUnit unit) {
      this.unit = Optional.ofNullable(unit);
      return this;
    }

    @JsonSetter(
        value = "inputCost",
        nulls = Nulls.SKIP
    )
    public Builder inputCost(Optional<Double> inputCost) {
      this.inputCost = inputCost;
      return this;
    }

    public Builder inputCost(Double inputCost) {
      this.inputCost = Optional.ofNullable(inputCost);
      return this;
    }

    @JsonSetter(
        value = "outputCost",
        nulls = Nulls.SKIP
    )
    public Builder outputCost(Optional<Double> outputCost) {
      this.outputCost = outputCost;
      return this;
    }

    public Builder outputCost(Double outputCost) {
      this.outputCost = Optional.ofNullable(outputCost);
      return this;
    }

    @JsonSetter(
        value = "totalCost",
        nulls = Nulls.SKIP
    )
    public Builder totalCost(Optional<Double> totalCost) {
      this.totalCost = totalCost;
      return this;
    }

    public Builder totalCost(Double totalCost) {
      this.totalCost = Optional.ofNullable(totalCost);
      return this;
    }

    public Usage build() {
      return new Usage(input, output, total, unit, inputCost, outputCost, totalCost, additionalProperties);
    }
  }
}
