/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ScoreConfig.Builder.class
)
public final class ScoreConfig {
  private final String id;

  private final String name;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final String projectId;

  private final ScoreDataType dataType;

  private final boolean isArchived;

  private final Optional<Double> minValue;

  private final Optional<Double> maxValue;

  private final Optional<List<ConfigCategory>> categories;

  private final Optional<String> description;

  private final Map<String, Object> additionalProperties;

  private ScoreConfig(String id, String name, OffsetDateTime createdAt, OffsetDateTime updatedAt,
      String projectId, ScoreDataType dataType, boolean isArchived, Optional<Double> minValue,
      Optional<Double> maxValue, Optional<List<ConfigCategory>> categories,
      Optional<String> description, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.projectId = projectId;
    this.dataType = dataType;
    this.isArchived = isArchived;
    this.minValue = minValue;
    this.maxValue = maxValue;
    this.categories = categories;
    this.description = description;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @JsonProperty("projectId")
  public String getProjectId() {
    return projectId;
  }

  @JsonProperty("dataType")
  public ScoreDataType getDataType() {
    return dataType;
  }

  /**
   * @return Whether the score config is archived. Defaults to false
   */
  @JsonProperty("isArchived")
  public boolean getIsArchived() {
    return isArchived;
  }

  /**
   * @return Sets minimum value for numerical scores. If not set, the minimum value defaults to -∞
   */
  @JsonProperty("minValue")
  public Optional<Double> getMinValue() {
    return minValue;
  }

  /**
   * @return Sets maximum value for numerical scores. If not set, the maximum value defaults to +∞
   */
  @JsonProperty("maxValue")
  public Optional<Double> getMaxValue() {
    return maxValue;
  }

  /**
   * @return Configures custom categories for categorical scores
   */
  @JsonProperty("categories")
  public Optional<List<ConfigCategory>> getCategories() {
    return categories;
  }

  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ScoreConfig && equalTo((ScoreConfig) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ScoreConfig other) {
    return id.equals(other.id) && name.equals(other.name) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && projectId.equals(other.projectId) && dataType.equals(other.dataType) && isArchived == other.isArchived && minValue.equals(other.minValue) && maxValue.equals(other.maxValue) && categories.equals(other.categories) && description.equals(other.description);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt, this.projectId, this.dataType, this.isArchived, this.minValue, this.maxValue, this.categories, this.description);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(ScoreConfig other);
  }

  public interface NameStage {
    CreatedAtStage name(@NotNull String name);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    ProjectIdStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface ProjectIdStage {
    DataTypeStage projectId(@NotNull String projectId);
  }

  public interface DataTypeStage {
    IsArchivedStage dataType(@NotNull ScoreDataType dataType);
  }

  public interface IsArchivedStage {
    _FinalStage isArchived(boolean isArchived);
  }

  public interface _FinalStage {
    ScoreConfig build();

    _FinalStage minValue(Optional<Double> minValue);

    _FinalStage minValue(Double minValue);

    _FinalStage maxValue(Optional<Double> maxValue);

    _FinalStage maxValue(Double maxValue);

    _FinalStage categories(Optional<List<ConfigCategory>> categories);

    _FinalStage categories(List<ConfigCategory> categories);

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, CreatedAtStage, UpdatedAtStage, ProjectIdStage, DataTypeStage, IsArchivedStage, _FinalStage {
    private String id;

    private String name;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private String projectId;

    private ScoreDataType dataType;

    private boolean isArchived;

    private Optional<String> description = Optional.empty();

    private Optional<List<ConfigCategory>> categories = Optional.empty();

    private Optional<Double> maxValue = Optional.empty();

    private Optional<Double> minValue = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ScoreConfig other) {
      id(other.getId());
      name(other.getName());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      projectId(other.getProjectId());
      dataType(other.getDataType());
      isArchived(other.getIsArchived());
      minValue(other.getMinValue());
      maxValue(other.getMaxValue());
      categories(other.getCategories());
      description(other.getDescription());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public CreatedAtStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("updatedAt")
    public ProjectIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("projectId")
    public DataTypeStage projectId(@NotNull String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("dataType")
    public IsArchivedStage dataType(@NotNull ScoreDataType dataType) {
      this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
      return this;
    }

    /**
     * <p>Whether the score config is archived. Defaults to false</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("isArchived")
    public _FinalStage isArchived(boolean isArchived) {
      this.isArchived = isArchived;
      return this;
    }

    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * <p>Configures custom categories for categorical scores</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage categories(List<ConfigCategory> categories) {
      this.categories = Optional.ofNullable(categories);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "categories",
        nulls = Nulls.SKIP
    )
    public _FinalStage categories(Optional<List<ConfigCategory>> categories) {
      this.categories = categories;
      return this;
    }

    /**
     * <p>Sets maximum value for numerical scores. If not set, the maximum value defaults to +∞</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage maxValue(Double maxValue) {
      this.maxValue = Optional.ofNullable(maxValue);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "maxValue",
        nulls = Nulls.SKIP
    )
    public _FinalStage maxValue(Optional<Double> maxValue) {
      this.maxValue = maxValue;
      return this;
    }

    /**
     * <p>Sets minimum value for numerical scores. If not set, the minimum value defaults to -∞</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage minValue(Double minValue) {
      this.minValue = Optional.ofNullable(minValue);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "minValue",
        nulls = Nulls.SKIP
    )
    public _FinalStage minValue(Optional<Double> minValue) {
      this.minValue = minValue;
      return this;
    }

    @java.lang.Override
    public ScoreConfig build() {
      return new ScoreConfig(id, name, createdAt, updatedAt, projectId, dataType, isArchived, minValue, maxValue, categories, description, additionalProperties);
    }
  }
}
