/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Object;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public final class Score {
  private final Value value;

  @JsonCreator(
      mode = JsonCreator.Mode.DELEGATING
  )
  private Score(Value value) {
    this.value = value;
  }

  public <T> T visit(Visitor<T> visitor) {
    return value.visit(visitor);
  }

  public static Score numeric(NumericScore value) {
    return new Score(new NumericValue(value));
  }

  public static Score categorical(CategoricalScore value) {
    return new Score(new CategoricalValue(value));
  }

  public static Score boolean_(BooleanScore value) {
    return new Score(new BooleanValue(value));
  }

  public boolean isNumeric() {
    return value instanceof NumericValue;
  }

  public boolean isCategorical() {
    return value instanceof CategoricalValue;
  }

  public boolean isBoolean() {
    return value instanceof BooleanValue;
  }

  public boolean _isUnknown() {
    return value instanceof _UnknownValue;
  }

  public Optional<NumericScore> getNumeric() {
    if (isNumeric()) {
      return Optional.of(((NumericValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<CategoricalScore> getCategorical() {
    if (isCategorical()) {
      return Optional.of(((CategoricalValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<BooleanScore> getBoolean() {
    if (isBoolean()) {
      return Optional.of(((BooleanValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<Object> _getUnknown() {
    if (_isUnknown()) {
      return Optional.of(((_UnknownValue) value).value);
    }
    return Optional.empty();
  }

  @JsonValue
  private Value getValue() {
    return this.value;
  }

  public interface Visitor<T> {
    T visitNumeric(NumericScore numeric);

    T visitCategorical(CategoricalScore categorical);

    T visitBoolean(BooleanScore boolean_);

    T _visitUnknown(Object unknownType);
  }

  @JsonTypeInfo(
      use = JsonTypeInfo.Id.NAME,
      property = "dataType",
      visible = true,
      defaultImpl = _UnknownValue.class
  )
  @JsonSubTypes({
      @JsonSubTypes.Type(NumericValue.class),
      @JsonSubTypes.Type(CategoricalValue.class),
      @JsonSubTypes.Type(BooleanValue.class)
  })
  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  private interface Value {
    <T> T visit(Visitor<T> visitor);
  }

  @JsonTypeName("NUMERIC")
  @JsonIgnoreProperties("dataType")
  private static final class NumericValue implements Value {
    @JsonUnwrapped
    private NumericScore value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private NumericValue() {
    }

    private NumericValue(NumericScore value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitNumeric(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof NumericValue && equalTo((NumericValue) other);
    }

    private boolean equalTo(NumericValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "Score{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("CATEGORICAL")
  @JsonIgnoreProperties("dataType")
  private static final class CategoricalValue implements Value {
    @JsonUnwrapped
    private CategoricalScore value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private CategoricalValue() {
    }

    private CategoricalValue(CategoricalScore value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitCategorical(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof CategoricalValue && equalTo((CategoricalValue) other);
    }

    private boolean equalTo(CategoricalValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "Score{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("BOOLEAN")
  @JsonIgnoreProperties("dataType")
  private static final class BooleanValue implements Value {
    @JsonUnwrapped
    private BooleanScore value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private BooleanValue() {
    }

    private BooleanValue(BooleanScore value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitBoolean(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof BooleanValue && equalTo((BooleanValue) other);
    }

    private boolean equalTo(BooleanValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "Score{" + "value: " + value + "}";
    }
  }

  @JsonIgnoreProperties("dataType")
  private static final class _UnknownValue implements Value {
    private String type;

    @JsonValue
    private Object value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private _UnknownValue(@JsonProperty("value") Object value) {
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor._visitUnknown(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
    }

    private boolean equalTo(_UnknownValue other) {
      return type.equals(other.type) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.type, this.value);
    }

    @java.lang.Override
    public String toString() {
      return "Score{" + "type: " + type + ", value: " + value + "}";
    }
  }
}
