/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Observation.Builder.class
)
public final class Observation implements IObservation {
  private final String id;

  private final Optional<String> traceId;

  private final String type;

  private final Optional<String> name;

  private final OffsetDateTime startTime;

  private final Optional<OffsetDateTime> endTime;

  private final Optional<OffsetDateTime> completionStartTime;

  private final Optional<String> model;

  private final Optional<Map<String, MapValue>> modelParameters;

  private final Optional<Object> input;

  private final Optional<String> version;

  private final Optional<Object> metadata;

  private final Optional<Object> output;

  private final Optional<Usage> usage;

  private final ObservationLevel level;

  private final Optional<String> statusMessage;

  private final Optional<String> parentObservationId;

  private final Optional<String> promptId;

  private final Optional<Map<String, Integer>> usageDetails;

  private final Optional<Map<String, Double>> costDetails;

  private final Optional<String> environment;

  private final Map<String, Object> additionalProperties;

  private Observation(String id, Optional<String> traceId, String type, Optional<String> name,
      OffsetDateTime startTime, Optional<OffsetDateTime> endTime,
      Optional<OffsetDateTime> completionStartTime, Optional<String> model,
      Optional<Map<String, MapValue>> modelParameters, Optional<Object> input,
      Optional<String> version, Optional<Object> metadata, Optional<Object> output,
      Optional<Usage> usage, ObservationLevel level, Optional<String> statusMessage,
      Optional<String> parentObservationId, Optional<String> promptId,
      Optional<Map<String, Integer>> usageDetails, Optional<Map<String, Double>> costDetails,
      Optional<String> environment, Map<String, Object> additionalProperties) {
    this.id = id;
    this.traceId = traceId;
    this.type = type;
    this.name = name;
    this.startTime = startTime;
    this.endTime = endTime;
    this.completionStartTime = completionStartTime;
    this.model = model;
    this.modelParameters = modelParameters;
    this.input = input;
    this.version = version;
    this.metadata = metadata;
    this.output = output;
    this.usage = usage;
    this.level = level;
    this.statusMessage = statusMessage;
    this.parentObservationId = parentObservationId;
    this.promptId = promptId;
    this.usageDetails = usageDetails;
    this.costDetails = costDetails;
    this.environment = environment;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier of the observation
   */
  @JsonProperty("id")
  @java.lang.Override
  public String getId() {
    return id;
  }

  /**
   * @return The trace ID associated with the observation
   */
  @JsonProperty("traceId")
  @java.lang.Override
  public Optional<String> getTraceId() {
    return traceId;
  }

  /**
   * @return The type of the observation
   */
  @JsonProperty("type")
  @java.lang.Override
  public String getType() {
    return type;
  }

  /**
   * @return The name of the observation
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The start time of the observation
   */
  @JsonProperty("startTime")
  @java.lang.Override
  public OffsetDateTime getStartTime() {
    return startTime;
  }

  /**
   * @return The end time of the observation.
   */
  @JsonProperty("endTime")
  @java.lang.Override
  public Optional<OffsetDateTime> getEndTime() {
    return endTime;
  }

  /**
   * @return The completion start time of the observation
   */
  @JsonProperty("completionStartTime")
  @java.lang.Override
  public Optional<OffsetDateTime> getCompletionStartTime() {
    return completionStartTime;
  }

  /**
   * @return The model used for the observation
   */
  @JsonProperty("model")
  @java.lang.Override
  public Optional<String> getModel() {
    return model;
  }

  /**
   * @return The parameters of the model used for the observation
   */
  @JsonProperty("modelParameters")
  @java.lang.Override
  public Optional<Map<String, MapValue>> getModelParameters() {
    return modelParameters;
  }

  /**
   * @return The input data of the observation
   */
  @JsonProperty("input")
  @java.lang.Override
  public Optional<Object> getInput() {
    return input;
  }

  /**
   * @return The version of the observation
   */
  @JsonProperty("version")
  @java.lang.Override
  public Optional<String> getVersion() {
    return version;
  }

  /**
   * @return Additional metadata of the observation
   */
  @JsonProperty("metadata")
  @java.lang.Override
  public Optional<Object> getMetadata() {
    return metadata;
  }

  /**
   * @return The output data of the observation
   */
  @JsonProperty("output")
  @java.lang.Override
  public Optional<Object> getOutput() {
    return output;
  }

  /**
   * @return (Deprecated. Use usageDetails and costDetails instead.) The usage data of the observation
   */
  @JsonProperty("usage")
  @java.lang.Override
  public Optional<Usage> getUsage() {
    return usage;
  }

  /**
   * @return The level of the observation
   */
  @JsonProperty("level")
  @java.lang.Override
  public ObservationLevel getLevel() {
    return level;
  }

  /**
   * @return The status message of the observation
   */
  @JsonProperty("statusMessage")
  @java.lang.Override
  public Optional<String> getStatusMessage() {
    return statusMessage;
  }

  /**
   * @return The parent observation ID
   */
  @JsonProperty("parentObservationId")
  @java.lang.Override
  public Optional<String> getParentObservationId() {
    return parentObservationId;
  }

  /**
   * @return The prompt ID associated with the observation
   */
  @JsonProperty("promptId")
  @java.lang.Override
  public Optional<String> getPromptId() {
    return promptId;
  }

  /**
   * @return The usage details of the observation. Key is the name of the usage metric, value is the number of units consumed. The total key is the sum of all (non-total) usage metrics or the total value ingested.
   */
  @JsonProperty("usageDetails")
  @java.lang.Override
  public Optional<Map<String, Integer>> getUsageDetails() {
    return usageDetails;
  }

  /**
   * @return The cost details of the observation. Key is the name of the cost metric, value is the cost in USD. The total key is the sum of all (non-total) cost metrics or the total value ingested.
   */
  @JsonProperty("costDetails")
  @java.lang.Override
  public Optional<Map<String, Double>> getCostDetails() {
    return costDetails;
  }

  /**
   * @return The environment from which this observation originated. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.
   */
  @JsonProperty("environment")
  @java.lang.Override
  public Optional<String> getEnvironment() {
    return environment;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Observation && equalTo((Observation) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Observation other) {
    return id.equals(other.id) && traceId.equals(other.traceId) && type.equals(other.type) && name.equals(other.name) && startTime.equals(other.startTime) && endTime.equals(other.endTime) && completionStartTime.equals(other.completionStartTime) && model.equals(other.model) && modelParameters.equals(other.modelParameters) && input.equals(other.input) && version.equals(other.version) && metadata.equals(other.metadata) && output.equals(other.output) && usage.equals(other.usage) && level.equals(other.level) && statusMessage.equals(other.statusMessage) && parentObservationId.equals(other.parentObservationId) && promptId.equals(other.promptId) && usageDetails.equals(other.usageDetails) && costDetails.equals(other.costDetails) && environment.equals(other.environment);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.promptId, this.usageDetails, this.costDetails, this.environment);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    TypeStage id(@NotNull String id);

    Builder from(Observation other);
  }

  public interface TypeStage {
    StartTimeStage type(@NotNull String type);
  }

  public interface StartTimeStage {
    LevelStage startTime(@NotNull OffsetDateTime startTime);
  }

  public interface LevelStage {
    _FinalStage level(@NotNull ObservationLevel level);
  }

  public interface _FinalStage {
    Observation build();

    _FinalStage traceId(Optional<String> traceId);

    _FinalStage traceId(String traceId);

    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    _FinalStage endTime(Optional<OffsetDateTime> endTime);

    _FinalStage endTime(OffsetDateTime endTime);

    _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime);

    _FinalStage completionStartTime(OffsetDateTime completionStartTime);

    _FinalStage model(Optional<String> model);

    _FinalStage model(String model);

    _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters);

    _FinalStage modelParameters(Map<String, MapValue> modelParameters);

    _FinalStage input(Optional<Object> input);

    _FinalStage input(Object input);

    _FinalStage version(Optional<String> version);

    _FinalStage version(String version);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage output(Optional<Object> output);

    _FinalStage output(Object output);

    _FinalStage usage(Optional<Usage> usage);

    _FinalStage usage(Usage usage);

    _FinalStage statusMessage(Optional<String> statusMessage);

    _FinalStage statusMessage(String statusMessage);

    _FinalStage parentObservationId(Optional<String> parentObservationId);

    _FinalStage parentObservationId(String parentObservationId);

    _FinalStage promptId(Optional<String> promptId);

    _FinalStage promptId(String promptId);

    _FinalStage usageDetails(Optional<Map<String, Integer>> usageDetails);

    _FinalStage usageDetails(Map<String, Integer> usageDetails);

    _FinalStage costDetails(Optional<Map<String, Double>> costDetails);

    _FinalStage costDetails(Map<String, Double> costDetails);

    _FinalStage environment(Optional<String> environment);

    _FinalStage environment(String environment);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, TypeStage, StartTimeStage, LevelStage, _FinalStage {
    private String id;

    private String type;

    private OffsetDateTime startTime;

    private ObservationLevel level;

    private Optional<String> environment = Optional.empty();

    private Optional<Map<String, Double>> costDetails = Optional.empty();

    private Optional<Map<String, Integer>> usageDetails = Optional.empty();

    private Optional<String> promptId = Optional.empty();

    private Optional<String> parentObservationId = Optional.empty();

    private Optional<String> statusMessage = Optional.empty();

    private Optional<Usage> usage = Optional.empty();

    private Optional<Object> output = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> version = Optional.empty();

    private Optional<Object> input = Optional.empty();

    private Optional<Map<String, MapValue>> modelParameters = Optional.empty();

    private Optional<String> model = Optional.empty();

    private Optional<OffsetDateTime> completionStartTime = Optional.empty();

    private Optional<OffsetDateTime> endTime = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> traceId = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(Observation other) {
      id(other.getId());
      traceId(other.getTraceId());
      type(other.getType());
      name(other.getName());
      startTime(other.getStartTime());
      endTime(other.getEndTime());
      completionStartTime(other.getCompletionStartTime());
      model(other.getModel());
      modelParameters(other.getModelParameters());
      input(other.getInput());
      version(other.getVersion());
      metadata(other.getMetadata());
      output(other.getOutput());
      usage(other.getUsage());
      level(other.getLevel());
      statusMessage(other.getStatusMessage());
      parentObservationId(other.getParentObservationId());
      promptId(other.getPromptId());
      usageDetails(other.getUsageDetails());
      costDetails(other.getCostDetails());
      environment(other.getEnvironment());
      return this;
    }

    /**
     * <p>The unique identifier of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public TypeStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    /**
     * <p>The type of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("type")
    public StartTimeStage type(@NotNull String type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    /**
     * <p>The start time of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("startTime")
    public LevelStage startTime(@NotNull OffsetDateTime startTime) {
      this.startTime = Objects.requireNonNull(startTime, "startTime must not be null");
      return this;
    }

    /**
     * <p>The level of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("level")
    public _FinalStage level(@NotNull ObservationLevel level) {
      this.level = Objects.requireNonNull(level, "level must not be null");
      return this;
    }

    /**
     * <p>The environment from which this observation originated. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public _FinalStage environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    /**
     * <p>The cost details of the observation. Key is the name of the cost metric, value is the cost in USD. The total key is the sum of all (non-total) cost metrics or the total value ingested.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage costDetails(Map<String, Double> costDetails) {
      this.costDetails = Optional.ofNullable(costDetails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "costDetails",
        nulls = Nulls.SKIP
    )
    public _FinalStage costDetails(Optional<Map<String, Double>> costDetails) {
      this.costDetails = costDetails;
      return this;
    }

    /**
     * <p>The usage details of the observation. Key is the name of the usage metric, value is the number of units consumed. The total key is the sum of all (non-total) usage metrics or the total value ingested.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage usageDetails(Map<String, Integer> usageDetails) {
      this.usageDetails = Optional.ofNullable(usageDetails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "usageDetails",
        nulls = Nulls.SKIP
    )
    public _FinalStage usageDetails(Optional<Map<String, Integer>> usageDetails) {
      this.usageDetails = usageDetails;
      return this;
    }

    /**
     * <p>The prompt ID associated with the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage promptId(String promptId) {
      this.promptId = Optional.ofNullable(promptId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "promptId",
        nulls = Nulls.SKIP
    )
    public _FinalStage promptId(Optional<String> promptId) {
      this.promptId = promptId;
      return this;
    }

    /**
     * <p>The parent observation ID</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage parentObservationId(String parentObservationId) {
      this.parentObservationId = Optional.ofNullable(parentObservationId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "parentObservationId",
        nulls = Nulls.SKIP
    )
    public _FinalStage parentObservationId(Optional<String> parentObservationId) {
      this.parentObservationId = parentObservationId;
      return this;
    }

    /**
     * <p>The status message of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage statusMessage(String statusMessage) {
      this.statusMessage = Optional.ofNullable(statusMessage);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "statusMessage",
        nulls = Nulls.SKIP
    )
    public _FinalStage statusMessage(Optional<String> statusMessage) {
      this.statusMessage = statusMessage;
      return this;
    }

    /**
     * <p>(Deprecated. Use usageDetails and costDetails instead.) The usage data of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage usage(Usage usage) {
      this.usage = Optional.ofNullable(usage);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "usage",
        nulls = Nulls.SKIP
    )
    public _FinalStage usage(Optional<Usage> usage) {
      this.usage = usage;
      return this;
    }

    /**
     * <p>The output data of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage output(Object output) {
      this.output = Optional.ofNullable(output);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "output",
        nulls = Nulls.SKIP
    )
    public _FinalStage output(Optional<Object> output) {
      this.output = output;
      return this;
    }

    /**
     * <p>Additional metadata of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * <p>The version of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public _FinalStage version(Optional<String> version) {
      this.version = version;
      return this;
    }

    /**
     * <p>The input data of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage input(Object input) {
      this.input = Optional.ofNullable(input);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "input",
        nulls = Nulls.SKIP
    )
    public _FinalStage input(Optional<Object> input) {
      this.input = input;
      return this;
    }

    /**
     * <p>The parameters of the model used for the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage modelParameters(Map<String, MapValue> modelParameters) {
      this.modelParameters = Optional.ofNullable(modelParameters);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "modelParameters",
        nulls = Nulls.SKIP
    )
    public _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters) {
      this.modelParameters = modelParameters;
      return this;
    }

    /**
     * <p>The model used for the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage model(String model) {
      this.model = Optional.ofNullable(model);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "model",
        nulls = Nulls.SKIP
    )
    public _FinalStage model(Optional<String> model) {
      this.model = model;
      return this;
    }

    /**
     * <p>The completion start time of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage completionStartTime(OffsetDateTime completionStartTime) {
      this.completionStartTime = Optional.ofNullable(completionStartTime);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "completionStartTime",
        nulls = Nulls.SKIP
    )
    public _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime) {
      this.completionStartTime = completionStartTime;
      return this;
    }

    /**
     * <p>The end time of the observation.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage endTime(OffsetDateTime endTime) {
      this.endTime = Optional.ofNullable(endTime);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "endTime",
        nulls = Nulls.SKIP
    )
    public _FinalStage endTime(Optional<OffsetDateTime> endTime) {
      this.endTime = endTime;
      return this;
    }

    /**
     * <p>The name of the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    /**
     * <p>The trace ID associated with the observation</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage traceId(String traceId) {
      this.traceId = Optional.ofNullable(traceId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "traceId",
        nulls = Nulls.SKIP
    )
    public _FinalStage traceId(Optional<String> traceId) {
      this.traceId = traceId;
      return this;
    }

    @java.lang.Override
    public Observation build() {
      return new Observation(id, traceId, type, name, startTime, endTime, completionStartTime, model, modelParameters, input, version, metadata, output, usage, level, statusMessage, parentObservationId, promptId, usageDetails, costDetails, environment, additionalProperties);
    }
  }
}
