/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DatasetRunWithItems.Builder.class
)
public final class DatasetRunWithItems implements IDatasetRun {
  private final String id;

  private final String name;

  private final Optional<String> description;

  private final Optional<Object> metadata;

  private final String datasetId;

  private final String datasetName;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final List<DatasetRunItem> datasetRunItems;

  private final Map<String, Object> additionalProperties;

  private DatasetRunWithItems(String id, String name, Optional<String> description,
      Optional<Object> metadata, String datasetId, String datasetName, OffsetDateTime createdAt,
      OffsetDateTime updatedAt, List<DatasetRunItem> datasetRunItems,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.metadata = metadata;
    this.datasetId = datasetId;
    this.datasetName = datasetName;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.datasetRunItems = datasetRunItems;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier of the dataset run
   */
  @JsonProperty("id")
  @java.lang.Override
  public String getId() {
    return id;
  }

  /**
   * @return Name of the dataset run
   */
  @JsonProperty("name")
  @java.lang.Override
  public String getName() {
    return name;
  }

  /**
   * @return Description of the run
   */
  @JsonProperty("description")
  @java.lang.Override
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Metadata of the dataset run
   */
  @JsonProperty("metadata")
  @java.lang.Override
  public Optional<Object> getMetadata() {
    return metadata;
  }

  /**
   * @return Id of the associated dataset
   */
  @JsonProperty("datasetId")
  @java.lang.Override
  public String getDatasetId() {
    return datasetId;
  }

  /**
   * @return Name of the associated dataset
   */
  @JsonProperty("datasetName")
  @java.lang.Override
  public String getDatasetName() {
    return datasetName;
  }

  /**
   * @return The date and time when the dataset run was created
   */
  @JsonProperty("createdAt")
  @java.lang.Override
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The date and time when the dataset run was last updated
   */
  @JsonProperty("updatedAt")
  @java.lang.Override
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @JsonProperty("datasetRunItems")
  public List<DatasetRunItem> getDatasetRunItems() {
    return datasetRunItems;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DatasetRunWithItems && equalTo((DatasetRunWithItems) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DatasetRunWithItems other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && metadata.equals(other.metadata) && datasetId.equals(other.datasetId) && datasetName.equals(other.datasetName) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && datasetRunItems.equals(other.datasetRunItems);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.metadata, this.datasetId, this.datasetName, this.createdAt, this.updatedAt, this.datasetRunItems);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(DatasetRunWithItems other);
  }

  public interface NameStage {
    DatasetIdStage name(@NotNull String name);
  }

  public interface DatasetIdStage {
    DatasetNameStage datasetId(@NotNull String datasetId);
  }

  public interface DatasetNameStage {
    CreatedAtStage datasetName(@NotNull String datasetName);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface _FinalStage {
    DatasetRunWithItems build();

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage datasetRunItems(List<DatasetRunItem> datasetRunItems);

    _FinalStage addDatasetRunItems(DatasetRunItem datasetRunItems);

    _FinalStage addAllDatasetRunItems(List<DatasetRunItem> datasetRunItems);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, DatasetIdStage, DatasetNameStage, CreatedAtStage, UpdatedAtStage, _FinalStage {
    private String id;

    private String name;

    private String datasetId;

    private String datasetName;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private List<DatasetRunItem> datasetRunItems = new ArrayList<>();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> description = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(DatasetRunWithItems other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      metadata(other.getMetadata());
      datasetId(other.getDatasetId());
      datasetName(other.getDatasetName());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      datasetRunItems(other.getDatasetRunItems());
      return this;
    }

    /**
     * <p>Unique identifier of the dataset run</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    /**
     * <p>Name of the dataset run</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public DatasetIdStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Id of the associated dataset</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("datasetId")
    public DatasetNameStage datasetId(@NotNull String datasetId) {
      this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
      return this;
    }

    /**
     * <p>Name of the associated dataset</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("datasetName")
    public CreatedAtStage datasetName(@NotNull String datasetName) {
      this.datasetName = Objects.requireNonNull(datasetName, "datasetName must not be null");
      return this;
    }

    /**
     * <p>The date and time when the dataset run was created</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    /**
     * <p>The date and time when the dataset run was last updated</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("updatedAt")
    public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllDatasetRunItems(List<DatasetRunItem> datasetRunItems) {
      this.datasetRunItems.addAll(datasetRunItems);
      return this;
    }

    @java.lang.Override
    public _FinalStage addDatasetRunItems(DatasetRunItem datasetRunItems) {
      this.datasetRunItems.add(datasetRunItems);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "datasetRunItems",
        nulls = Nulls.SKIP
    )
    public _FinalStage datasetRunItems(List<DatasetRunItem> datasetRunItems) {
      this.datasetRunItems.clear();
      this.datasetRunItems.addAll(datasetRunItems);
      return this;
    }

    /**
     * <p>Metadata of the dataset run</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * <p>Description of the run</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    @java.lang.Override
    public DatasetRunWithItems build() {
      return new DatasetRunWithItems(id, name, description, metadata, datasetId, datasetName, createdAt, updatedAt, datasetRunItems, additionalProperties);
    }
  }
}
