/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Comment.Builder.class
)
public final class Comment {
  private final String id;

  private final String projectId;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final CommentObjectType objectType;

  private final String objectId;

  private final String content;

  private final Optional<String> authorUserId;

  private final Map<String, Object> additionalProperties;

  private Comment(String id, String projectId, OffsetDateTime createdAt, OffsetDateTime updatedAt,
      CommentObjectType objectType, String objectId, String content, Optional<String> authorUserId,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.projectId = projectId;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.objectType = objectType;
    this.objectId = objectId;
    this.content = content;
    this.authorUserId = authorUserId;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("projectId")
  public String getProjectId() {
    return projectId;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @JsonProperty("objectType")
  public CommentObjectType getObjectType() {
    return objectType;
  }

  @JsonProperty("objectId")
  public String getObjectId() {
    return objectId;
  }

  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  @JsonProperty("authorUserId")
  public Optional<String> getAuthorUserId() {
    return authorUserId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Comment && equalTo((Comment) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Comment other) {
    return id.equals(other.id) && projectId.equals(other.projectId) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && objectType.equals(other.objectType) && objectId.equals(other.objectId) && content.equals(other.content) && authorUserId.equals(other.authorUserId);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.projectId, this.createdAt, this.updatedAt, this.objectType, this.objectId, this.content, this.authorUserId);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    ProjectIdStage id(@NotNull String id);

    Builder from(Comment other);
  }

  public interface ProjectIdStage {
    CreatedAtStage projectId(@NotNull String projectId);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    ObjectTypeStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface ObjectTypeStage {
    ObjectIdStage objectType(@NotNull CommentObjectType objectType);
  }

  public interface ObjectIdStage {
    ContentStage objectId(@NotNull String objectId);
  }

  public interface ContentStage {
    _FinalStage content(@NotNull String content);
  }

  public interface _FinalStage {
    Comment build();

    _FinalStage authorUserId(Optional<String> authorUserId);

    _FinalStage authorUserId(String authorUserId);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, ProjectIdStage, CreatedAtStage, UpdatedAtStage, ObjectTypeStage, ObjectIdStage, ContentStage, _FinalStage {
    private String id;

    private String projectId;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private CommentObjectType objectType;

    private String objectId;

    private String content;

    private Optional<String> authorUserId = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(Comment other) {
      id(other.getId());
      projectId(other.getProjectId());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      objectType(other.getObjectType());
      objectId(other.getObjectId());
      content(other.getContent());
      authorUserId(other.getAuthorUserId());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public ProjectIdStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("projectId")
    public CreatedAtStage projectId(@NotNull String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("updatedAt")
    public ObjectTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectType")
    public ObjectIdStage objectType(@NotNull CommentObjectType objectType) {
      this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectId")
    public ContentStage objectId(@NotNull String objectId) {
      this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("content")
    public _FinalStage content(@NotNull String content) {
      this.content = Objects.requireNonNull(content, "content must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage authorUserId(String authorUserId) {
      this.authorUserId = Optional.ofNullable(authorUserId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "authorUserId",
        nulls = Nulls.SKIP
    )
    public _FinalStage authorUserId(Optional<String> authorUserId) {
      this.authorUserId = authorUserId;
      return this;
    }

    @java.lang.Override
    public Comment build() {
      return new Comment(id, projectId, createdAt, updatedAt, objectType, objectId, content, authorUserId, additionalProperties);
    }
  }
}
