/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.core;

import java.lang.Integer;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class RequestOptions {
  private final String xLangfuseSdkName;

  private final String xLangfuseSdkVersion;

  private final String xLangfusePublicKey;

  private final Optional<Integer> timeout;

  private final TimeUnit timeoutTimeUnit;

  private final Map<String, String> headers;

  private final Map<String, Supplier<String>> headerSuppliers;

  private RequestOptions(String xLangfuseSdkName, String xLangfuseSdkVersion,
      String xLangfusePublicKey, Optional<Integer> timeout, TimeUnit timeoutTimeUnit,
      Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers) {
    this.xLangfuseSdkName = xLangfuseSdkName;
    this.xLangfuseSdkVersion = xLangfuseSdkVersion;
    this.xLangfusePublicKey = xLangfusePublicKey;
    this.timeout = timeout;
    this.timeoutTimeUnit = timeoutTimeUnit;
    this.headers = headers;
    this.headerSuppliers = headerSuppliers;
  }

  public Optional<Integer> getTimeout() {
    return timeout;
  }

  public TimeUnit getTimeoutTimeUnit() {
    return timeoutTimeUnit;
  }

  public Map<String, String> getHeaders() {
    Map<String, String> headers = new HashMap<>();
    if (this.xLangfuseSdkName != null) {
      headers.put("X-Langfuse-Sdk-Name", this.xLangfuseSdkName);
    }
    if (this.xLangfuseSdkVersion != null) {
      headers.put("X-Langfuse-Sdk-Version", this.xLangfuseSdkVersion);
    }
    if (this.xLangfusePublicKey != null) {
      headers.put("X-Langfuse-Public-Key", this.xLangfusePublicKey);
    }
    headers.putAll(this.headers);
    this.headerSuppliers.forEach((key, supplier) ->  {
      headers.put(key, supplier.get());
    } );
    return headers;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static final class Builder {
    private String xLangfuseSdkName = null;

    private String xLangfuseSdkVersion = null;

    private String xLangfusePublicKey = null;

    private Optional<Integer> timeout = Optional.empty();

    private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;

    private final Map<String, String> headers = new HashMap<>();

    private final Map<String, Supplier<String>> headerSuppliers = new HashMap<>();

    public Builder xLangfuseSdkName(String xLangfuseSdkName) {
      this.xLangfuseSdkName = xLangfuseSdkName;
      return this;
    }

    public Builder xLangfuseSdkVersion(String xLangfuseSdkVersion) {
      this.xLangfuseSdkVersion = xLangfuseSdkVersion;
      return this;
    }

    public Builder xLangfusePublicKey(String xLangfusePublicKey) {
      this.xLangfusePublicKey = xLangfusePublicKey;
      return this;
    }

    public Builder timeout(Integer timeout) {
      this.timeout = Optional.of(timeout);
      return this;
    }

    public Builder timeout(Integer timeout, TimeUnit timeoutTimeUnit) {
      this.timeout = Optional.of(timeout);
      this.timeoutTimeUnit = timeoutTimeUnit;
      return this;
    }

    public Builder addHeader(String key, String value) {
      this.headers.put(key, value);
      return this;
    }

    public Builder addHeader(String key, Supplier<String> value) {
      this.headerSuppliers.put(key, value);
      return this;
    }

    public RequestOptions build() {
      return new RequestOptions(xLangfuseSdkName, xLangfuseSdkVersion, xLangfusePublicKey, timeout, timeoutTimeUnit, headers, headerSuppliers);
    }
  }
}
