/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PKCertificate;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureResult;
import com.lacunasoftware.pkiexpress.Signer;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class XmlSigner
extends Signer {
    private Path xmlToSignPath;
    private String toSignElementId;

    public XmlSigner(PkiExpressConfig config) {
        super(config);
    }

    public XmlSigner() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setXmlToSign(InputStream inputStream) throws IOException {
        this.xmlToSignPath = this.writeToTempFile(inputStream);
    }

    public void setXmlToSign(byte[] content) throws IOException {
        this.setXmlToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setXmlToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.xmlToSignPath = path;
    }

    public void setXmlToSign(String path) throws IOException {
        this.setXmlToSign(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setToSignElementId(String toSignElementId) {
        this.toSignElementId = toSignElementId;
    }

    public PKCertificate sign() throws IOException {
        return this.sign(false);
    }

    public PKCertificate sign(boolean getCert) throws IOException {
        if (this.xmlToSignPath == null) {
            throw new RuntimeException("The file to be signed was not set");
        }
        if (this.outputFilePath == null) {
            throw new RuntimeException("The output destination was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.xmlToSignPath.toString());
        args.add(this.outputFilePath.toString());
        this.verifyAndAddCommonOptions(args);
        if (!Util.isNullOrEmpty(this.toSignElementId)) {
            args.add("--element-id");
            args.add(this.toSignElementId);
        }
        if (getCert) {
            this.versionManager.requireVersion(new Version("1.8"));
            OperatorResult result = this.invoke(CommandEnum.CommandSignXml, args);
            SignatureResult resultModel = this.parseOutput(result.getOutput()[0], SignatureResult.class);
            return new PKCertificate(resultModel.getSigner());
        }
        this.invokePlain(CommandEnum.CommandSignXml, args);
        return null;
    }
}

