/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureStartResult;
import com.lacunasoftware.pkiexpress.SignatureStarter;
import com.lacunasoftware.pkiexpress.Util;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class XmlSignatureStarter
extends SignatureStarter {
    private Path xmlToSignPath;
    private String toSignElementId;

    public XmlSignatureStarter(PkiExpressConfig config) {
        super(config);
    }

    public XmlSignatureStarter() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setXmlToSign(InputStream inputStream) throws IOException {
        this.xmlToSignPath = this.writeToTempFile(inputStream);
    }

    public void setXmlToSign(byte[] content) throws IOException {
        this.setXmlToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setXmlToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.xmlToSignPath = path;
    }

    public void setXmlToSign(String path) throws IOException {
        this.setXmlToSign(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setToSignElementId(String toSignElementId) {
        this.toSignElementId = toSignElementId;
    }

    public SignatureStartResult start() throws IOException {
        if (this.xmlToSignPath == null) {
            throw new RuntimeException("The XML to be signed was not set");
        }
        if (this.certificatePath == null) {
            throw new RuntimeException("The certificate was not set");
        }
        String transferFile = this.getTransferFileName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.xmlToSignPath.toString());
        args.add(this.certificatePath.toString());
        args.add(this.config.getTransferDataFolder().resolve(transferFile).toString());
        this.verifyAndAddCommonOptions(args);
        if (!Util.isNullOrEmpty(this.toSignElementId)) {
            args.add("--element-id");
            args.add(this.toSignElementId);
        }
        String[] response = this.invokePlain(CommandEnum.CommandStartXml, args);
        return this.getResult(response, transferFile);
    }
}

