/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.ValidationItem;
import com.lacunasoftware.pkiexpress.ValidationItemModel;
import com.lacunasoftware.pkiexpress.ValidationResultsModel;
import java.util.ArrayList;
import java.util.List;

public class ValidationResults {
    private List<ValidationItem> passedChecks = new ArrayList<ValidationItem>();
    private List<ValidationItem> errors = new ArrayList<ValidationItem>();
    private List<ValidationItem> warnings = new ArrayList<ValidationItem>();

    ValidationResults(ValidationResultsModel model) {
        ValidationResults.convertItems(model.getPassedChecks(), this.passedChecks);
        ValidationResults.convertItems(model.getWarnings(), this.warnings);
        ValidationResults.convertItems(model.getErrors(), this.errors);
    }

    public List<ValidationItem> getPassedChecks() {
        return this.passedChecks;
    }

    public List<ValidationItem> getWarnings() {
        return this.warnings;
    }

    public List<ValidationItem> getErrors() {
        return this.errors;
    }

    public int getChecksPerformed() {
        return this.passedChecks.size() + this.warnings.size() + this.errors.size();
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public String getSummary() {
        return this.getSummary(0);
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int identationLevel) {
        String tab = Util.repeatChar('\t', identationLevel);
        StringBuilder text = new StringBuilder();
        text.append(this.getSummary(identationLevel));
        if (this.hasErrors()) {
            text.append('\n');
            text.append(tab);
            text.append("Errors:");
            text.append('\n');
            ValidationResults.appendItems(text, this.errors, identationLevel);
        }
        if (this.hasWarnings()) {
            text.append('\n');
            text.append(tab);
            text.append("Warnings:");
            text.append('\n');
            ValidationResults.appendItems(text, this.warnings, identationLevel);
        }
        if (!this.passedChecks.isEmpty()) {
            text.append('\n');
            text.append(tab);
            text.append("Passed checks:");
            text.append('\n');
            ValidationResults.appendItems(text, this.passedChecks, identationLevel);
        }
        return text.toString();
    }

    private String getSummary(int identationLevel) {
        String tab = Util.repeatChar('\t', identationLevel);
        StringBuilder text = new StringBuilder();
        text.append(tab);
        text.append("Validation results: ");
        if (this.getChecksPerformed() == 0) {
            text.append("no checks performed");
        } else {
            text.append(String.format("%d checks performed", this.getChecksPerformed()));
            if (this.hasErrors()) {
                text.append(String.format(", %d errors", this.errors.size()));
            }
            if (this.hasWarnings()) {
                text.append(String.format(", %d warnings", this.warnings.size()));
            }
            if (!this.passedChecks.isEmpty()) {
                if (!this.hasErrors() && !this.hasWarnings()) {
                    text.append(", all passed");
                } else {
                    text.append(String.format(", %d passed", this.passedChecks.size()));
                }
            }
        }
        return text.toString();
    }

    private static void convertItems(List<ValidationItemModel> from, List<ValidationItem> to) {
        for (ValidationItemModel model : from) {
            to.add(new ValidationItem(model));
        }
    }

    private static void appendItems(StringBuilder text, List<ValidationItem> items, int identationLevel) {
        boolean isFirst = true;
        String tab = Util.repeatChar('\t', identationLevel);
        for (ValidationItem item : items) {
            if (isFirst) {
                isFirst = false;
            } else {
                text.append('\n');
            }
            text.append(tab);
            text.append("- ");
            text.append(item.toString(identationLevel));
        }
    }
}

