/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.ValidationItemModel;
import com.lacunasoftware.pkiexpress.ValidationItemTypes;
import com.lacunasoftware.pkiexpress.ValidationResults;

public class ValidationItem {
    private ValidationItemTypes type;
    private String message;
    private String detail;
    private ValidationResults innerValidationResults;

    ValidationItem(ValidationItemModel model) {
        this.type = ValidationItemTypes.valueOf(model.getType().toString());
        this.message = model.getMessage();
        this.detail = model.getDetail();
        if (model.getInnerValidationResults() != null) {
            this.innerValidationResults = new ValidationResults(model.getInnerValidationResults());
        }
    }

    public ValidationItemTypes getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.detail;
    }

    public ValidationResults getInnerValidationResults() {
        return this.innerValidationResults;
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int identationLevel) {
        String tab = Util.repeatChar('\t', identationLevel);
        StringBuilder text = new StringBuilder();
        text.append(this.message);
        if (!Util.isNullOrEmpty(this.detail)) {
            text.append(String.format(" (%s)", this.detail));
        }
        if (this.innerValidationResults != null) {
            text.append('\n');
            text.append(this.innerValidationResults.toString(identationLevel + 1));
        }
        return text.toString();
    }
}

