/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CheckServiceResult;
import com.lacunasoftware.pkiexpress.CheckServiceResultModel;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.DiscoverServicesResultModel;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.TrustServiceAuthParameters;
import com.lacunasoftware.pkiexpress.TrustServiceAuthParametersModel;
import com.lacunasoftware.pkiexpress.TrustServiceInfo;
import com.lacunasoftware.pkiexpress.TrustServiceInfoModel;
import com.lacunasoftware.pkiexpress.TrustServiceSessionResult;
import com.lacunasoftware.pkiexpress.TrustServiceSessionResultModel;
import com.lacunasoftware.pkiexpress.TrustServiceSessionTypes;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TrustServicesManager
extends PkiExpressOperator {
    public TrustServicesManager(PkiExpressConfig config) {
        super(config);
    }

    public TrustServicesManager() throws IOException {
        this(new PkiExpressConfig());
    }

    public CheckServiceResult checkByCpf(String service, String cpf) throws IOException {
        if (Util.isNullOrEmpty(service)) {
            throw new RuntimeException("The provided service is not valid");
        }
        if (Util.isNullOrEmpty(cpf)) {
            throw new RuntimeException("The provided CPF is not valid");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(service);
        args.add("--cpf");
        args.add(cpf);
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandCheckService, args);
        CheckServiceResultModel model = this.parseOutput(response.getOutput()[0], CheckServiceResultModel.class);
        return new CheckServiceResult(model);
    }

    public CheckServiceResult checkByCnpj(String service, String cnpj) throws IOException {
        if (Util.isNullOrEmpty(service)) {
            throw new RuntimeException("The provided service is not valid");
        }
        if (Util.isNullOrEmpty(cnpj)) {
            throw new RuntimeException("The provided CNPJ is not valid");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(service);
        args.add("--cnpj");
        args.add(cnpj);
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandCheckService, args);
        CheckServiceResultModel model = this.parseOutput(response.getOutput()[0], CheckServiceResultModel.class);
        return new CheckServiceResult(model);
    }

    public List<TrustServiceInfo> discoverByCpf(String cpf) throws IOException {
        return this.discoverByCpf(cpf, false);
    }

    public List<TrustServiceInfo> discoverByCpf(String cpf, boolean throwExceptions) throws IOException {
        if (Util.isNullOrEmpty(cpf)) {
            throw new RuntimeException("The provided CPF is not valid");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--cpf");
        args.add(cpf);
        if (throwExceptions) {
            args.add("--throw");
        }
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandDiscoverServices, args);
        DiscoverServicesResultModel model = this.parseOutput(response.getOutput()[0], DiscoverServicesResultModel.class);
        ArrayList<TrustServiceInfo> services = new ArrayList<TrustServiceInfo>();
        for (TrustServiceInfoModel serviceModel : model.getServices()) {
            services.add(new TrustServiceInfo(serviceModel));
        }
        return services;
    }

    public List<TrustServiceInfo> discoverByCnpj(String cnpj) throws IOException {
        return this.discoverByCnpj(cnpj, false);
    }

    public List<TrustServiceInfo> discoverByCnpj(String cnpj, boolean throwExceptions) throws IOException {
        if (Util.isNullOrEmpty(cnpj)) {
            throw new RuntimeException("The provided CNPJ is not valid");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--cnpj");
        args.add(cnpj);
        if (throwExceptions) {
            args.add("--throw");
        }
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandDiscoverServices, args);
        DiscoverServicesResultModel model = this.parseOutput(response.getOutput()[0], DiscoverServicesResultModel.class);
        ArrayList<TrustServiceInfo> services = new ArrayList<TrustServiceInfo>();
        for (TrustServiceInfoModel serviceModel : model.getServices()) {
            services.add(new TrustServiceInfo(serviceModel));
        }
        return services;
    }

    public List<TrustServiceAuthParameters> discoverByCpfAndStartAuth(String cpf, String redirectUrl) throws IOException {
        return this.discoverByCpfAndStartAuth(cpf, redirectUrl, TrustServiceSessionTypes.SIGNATURE_SESSION);
    }

    public List<TrustServiceAuthParameters> discoverByCpfAndStartAuth(String cpf, String redirectUrl, TrustServiceSessionTypes sessionType) throws IOException {
        return this.discoverByCpfAndStartAuth(cpf, redirectUrl, sessionType, null);
    }

    public List<TrustServiceAuthParameters> discoverByCpfAndStartAuth(String cpf, String redirectUrl, TrustServiceSessionTypes sessionType, String customState) throws IOException {
        return this.discoverByCpfAndStartAuth(cpf, redirectUrl, sessionType, customState, false);
    }

    public List<TrustServiceAuthParameters> discoverByCpfAndStartAuth(String cpf, String redirectUrl, TrustServiceSessionTypes sessionType, String customState, boolean throwExceptions) throws IOException {
        if (Util.isNullOrEmpty(cpf)) {
            throw new RuntimeException("The provided CPF is not valid");
        }
        if (Util.isNullOrEmpty(redirectUrl)) {
            throw new RuntimeException("The provided redirectUrl is not valid");
        }
        if (sessionType == null) {
            throw new RuntimeException("No sessionType was provided");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--cpf");
        args.add(cpf);
        args.add("--redirect-url");
        args.add(redirectUrl);
        if (sessionType != null) {
            args.add("--session-type");
            args.add(sessionType.getValue());
        }
        if (customState != null) {
            args.add("--custom-state");
            args.add(customState);
        }
        if (throwExceptions) {
            args.add("--throw");
        }
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandDiscoverServices, args);
        DiscoverServicesResultModel model = this.parseOutput(response.getOutput()[0], DiscoverServicesResultModel.class);
        ArrayList<TrustServiceAuthParameters> authParameters = new ArrayList<TrustServiceAuthParameters>();
        for (TrustServiceAuthParametersModel authParametersModel : model.getAuthParameters()) {
            authParameters.add(new TrustServiceAuthParameters(authParametersModel));
        }
        return authParameters;
    }

    public List<TrustServiceAuthParameters> discoverByCnpjAndStartAuth(String cnpj, String redirectUrl) throws IOException {
        return this.discoverByCnpjAndStartAuth(cnpj, redirectUrl, TrustServiceSessionTypes.SIGNATURE_SESSION);
    }

    public List<TrustServiceAuthParameters> discoverByCnpjAndStartAuth(String cnpj, String redirectUrl, TrustServiceSessionTypes sessionType) throws IOException {
        return this.discoverByCnpjAndStartAuth(cnpj, redirectUrl, sessionType, null);
    }

    public List<TrustServiceAuthParameters> discoverByCnpjAndStartAuth(String cnpj, String redirectUrl, TrustServiceSessionTypes sessionType, String customState) throws IOException {
        return this.discoverByCnpjAndStartAuth(cnpj, redirectUrl, sessionType, customState, false);
    }

    public List<TrustServiceAuthParameters> discoverByCnpjAndStartAuth(String cnpj, String redirectUrl, TrustServiceSessionTypes sessionType, String customState, boolean throwExceptions) throws IOException {
        if (Util.isNullOrEmpty(cnpj)) {
            throw new RuntimeException("The provided CNPJ is not valid");
        }
        if (Util.isNullOrEmpty(redirectUrl)) {
            throw new RuntimeException("The provided redirectUrl is not valid");
        }
        if (sessionType == null) {
            throw new RuntimeException("No sessionType was provided");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--cnpj");
        args.add(cnpj);
        args.add("--redirect-url");
        args.add(redirectUrl);
        args.add("--session-type");
        args.add(sessionType.getValue());
        if (customState != null) {
            args.add("--custom-state");
            args.add(customState);
        }
        if (throwExceptions) {
            args.add("--throw");
        }
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandDiscoverServices, args);
        DiscoverServicesResultModel model = this.parseOutput(response.getOutput()[0], DiscoverServicesResultModel.class);
        ArrayList<TrustServiceAuthParameters> authParameters = new ArrayList<TrustServiceAuthParameters>();
        for (TrustServiceAuthParametersModel authParametersModel : model.getAuthParameters()) {
            authParameters.add(new TrustServiceAuthParameters(authParametersModel));
        }
        return authParameters;
    }

    public TrustServiceSessionResult passwordAuthorize(String service, String username, String password) throws IOException {
        return this.passwordAuthorize(service, username, password, TrustServiceSessionTypes.SIGNATURE_SESSION);
    }

    public TrustServiceSessionResult passwordAuthorize(String service, String username, String password, TrustServiceSessionTypes sessionType) throws IOException {
        if (Util.isNullOrEmpty(service)) {
            throw new RuntimeException("The provided service is not valid");
        }
        if (Util.isNullOrEmpty(username)) {
            throw new RuntimeException("The provided username is not valid");
        }
        if (Util.isNullOrEmpty(password)) {
            throw new RuntimeException("The provided password is not valid");
        }
        if (sessionType == null) {
            throw new RuntimeException("No sessionType was provided");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(service);
        args.add(username);
        args.add(password);
        args.add(sessionType.getValue());
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandPasswordAuthorize, args);
        TrustServiceSessionResultModel model = this.parseOutput(response.getOutput()[0], TrustServiceSessionResultModel.class);
        return new TrustServiceSessionResult(model);
    }

    public TrustServiceSessionResult completeAuth(String code, String state) throws IOException {
        if (Util.isNullOrEmpty(code)) {
            throw new RuntimeException("The provided code is not valid");
        }
        if (Util.isNullOrEmpty(state)) {
            throw new RuntimeException("The provided state is not valid");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(code);
        args.add(state);
        this.versionManager.requireVersion(new Version("1.17"));
        OperatorResult response = this.invoke(CommandEnum.CommandCompleteServiceAuth, args);
        TrustServiceSessionResultModel model = this.parseOutput(response.getOutput()[0], TrustServiceSessionResultModel.class);
        return new TrustServiceSessionResult(model);
    }
}

