/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.TrustServiceSessionResultModel;
import com.lacunasoftware.pkiexpress.TrustServiceSessionTypes;
import com.lacunasoftware.pkiexpress.Util;
import java.util.Date;

public class TrustServiceSessionResult {
    private String session;
    private String service;
    private TrustServiceSessionTypes type;
    private Date expiresOn;
    private String customState;

    public TrustServiceSessionResult(TrustServiceSessionResultModel model) {
        this.session = model.getSession();
        this.customState = model.getCustomState();
        if (model.getExpiresOn() != null) {
            this.expiresOn = Util.parseApiDate(model.getExpiresOn());
        }
        if (model.getService() != null) {
            this.service = model.getService().getName();
        }
        if (model.getType() != null) {
            TrustServiceSessionTypes type = null;
            for (TrustServiceSessionTypes t : TrustServiceSessionTypes.values()) {
                if (!t.getValue().equals(model.getType().name())) continue;
                type = t;
            }
            if (type == null) {
                throw new RuntimeException("Invalid TrustServiceSessionTypes value.");
            }
            this.type = type;
        }
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public TrustServiceSessionTypes getType() {
        return this.type;
    }

    public void setType(TrustServiceSessionTypes type) {
        this.type = type;
    }

    public Date getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(Date expiresOn) {
        this.expiresOn = expiresOn;
    }

    public String getCustomState() {
        return this.customState;
    }

    public void setCustomState(String customState) {
        this.customState = customState;
    }
}

