/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.TsaAuthenticationType;
import java.util.ArrayList;
import java.util.List;

public class TimestampAuthority {
    private String url;
    private String token;
    private String sslThumbprint;
    private String basicAuth;
    private TsaAuthenticationType authType;

    public TimestampAuthority(String url) {
        this.url = url;
        this.authType = TsaAuthenticationType.None;
    }

    public void setOAuthTokenAuthentication(String token) {
        this.token = token;
        this.authType = TsaAuthenticationType.OAuthToken;
    }

    public void setBasicAuthentication(String username, String password) {
        this.basicAuth = String.format("%s:%s", username, password);
        this.authType = TsaAuthenticationType.BasicAuth;
    }

    public void setSSLThumbprint(String sslThumbprint) {
        this.sslThumbprint = sslThumbprint;
        this.authType = TsaAuthenticationType.SSL;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getSslThumbprint() {
        return this.sslThumbprint;
    }

    public String getBasicAuth() {
        return this.basicAuth;
    }

    public TsaAuthenticationType getAuthType() {
        return this.authType;
    }

    List<String> getCmdArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--tsa-url");
        args.add(this.url);
        switch (this.authType) {
            case None: {
                break;
            }
            case BasicAuth: {
                args.add("--tsa-basic-auth");
                args.add(this.basicAuth);
                break;
            }
            case SSL: {
                args.add("--tsa-ssl-thumbprint");
                args.add(this.sslThumbprint);
                break;
            }
            case OAuthToken: {
                args.add("--tsa-token");
                args.add(this.token);
                break;
            }
            default: {
                throw new RuntimeException("Unknown authentication type of the timestamp authority");
            }
        }
        return args;
    }
}

