/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.BaseSigner;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

abstract class Signer
extends BaseSigner {
    protected Path outputFilePath;
    private String certThumb;
    private Path pkcs12Path;
    private String certPassword;
    private boolean useMachine;
    private String trustServiceSession;

    public Signer(PkiExpressConfig config) {
        super(config);
    }

    public Signer() throws IOException {
        this(new PkiExpressConfig());
    }

    @Override
    protected void verifyAndAddCommonOptions(List<String> args) {
        super.verifyAndAddCommonOptions(args);
        if (this.certThumb == null && this.pkcs12Path == null && this.trustServiceSession == null) {
            throw new RuntimeException("No PKCS #12 file, certificate's thumbprint or TrustServiceSession was provided");
        }
        if (this.certThumb != null) {
            args.add("--thumbprint");
            args.add(this.certThumb);
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.pkcs12Path != null) {
            args.add("--pkcs12");
            args.add(this.pkcs12Path.toString());
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.certPassword != null) {
            args.add("--password");
            args.add(this.certPassword);
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.useMachine) {
            args.add("--machine");
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.trustServiceSession != null) {
            args.add("--trust-service-session");
            args.add(this.trustServiceSession);
            this.versionManager.requireVersion(new Version("1.17"));
        }
    }

    public void setOutputFile(Path path) {
        this.outputFilePath = path;
    }

    public void setCertificateThumbprint(String certThumb) {
        this.certThumb = certThumb;
    }

    public void setPkcs12(InputStream inputStream) throws IOException {
        this.pkcs12Path = this.writeToTempFile(inputStream);
    }

    public void setPkcs12(byte[] content) throws IOException {
        this.setPkcs12(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setPkcs12(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided PKCS #12 certificate file was not found");
        }
        this.pkcs12Path = path;
    }

    public void setPkcs12(String path) throws IOException {
        this.setPkcs12(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setCertPassword(String password) {
        this.certPassword = password;
    }

    public void setUseMachine(boolean useMachine) {
        this.useMachine = useMachine;
    }

    public String getTrustServiceSession() {
        return this.trustServiceSession;
    }

    public void setTrustServiceSession(String trustServiceSession) {
        this.trustServiceSession = trustServiceSession;
    }
}

