/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.BaseSigner;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureStartResult;
import com.lacunasoftware.pkiexpress.Util;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SignatureStarter
extends BaseSigner {
    protected Path certificatePath;

    public SignatureStarter(PkiExpressConfig config) {
        super(config);
    }

    public SignatureStarter() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setCertificate(InputStream inputStream) throws IOException {
        this.certificatePath = this.writeToTempFile(inputStream);
    }

    public void setCertificate(byte[] content) throws IOException {
        this.setCertificate(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setCertificate(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided certificate was not found");
        }
        this.certificatePath = path;
    }

    public void setCertificate(String path) throws IOException {
        this.setCertificate(Paths.get(path, new String[0]));
    }

    public void setCertificateBase64(String contentBase64) throws IOException {
        byte[] contentRaw = Util.decodeBase64(contentBase64);
        this.setCertificate(contentRaw);
    }

    protected SignatureStartResult getResult(String[] response, String transferFile) {
        SignatureStartResult startResult = new SignatureStartResult();
        startResult.setToSignHash(response[0]);
        startResult.setDigestAlgorithm(response[1]);
        startResult.setDigestAlgorithmOid(response[2]);
        startResult.setTransferFile(transferFile);
        return startResult;
    }
}

