/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PKCertificate;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.SignatureResult;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class SignatureFinisher
extends PkiExpressOperator {
    private Path fileToSignPath;
    private String transferFileId;
    private Path dataFilePath;
    private Path outputFilePath;
    private String signature;

    public SignatureFinisher(PkiExpressConfig config) {
        super(config);
    }

    public SignatureFinisher() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setFileToSign(InputStream inputStream) throws IOException {
        int nRead;
        byte[] buff = new byte[1024];
        Path tempPath = this.createTempFile();
        FileOutputStream outputStream = new FileOutputStream(tempPath.toFile());
        while ((nRead = inputStream.read(buff, 0, buff.length)) != -1) {
            ((OutputStream)outputStream).write(buff, 0, nRead);
        }
        ((OutputStream)outputStream).close();
        this.fileToSignPath = tempPath;
    }

    public void setFileToSign(byte[] content) throws IOException {
        this.setFileToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setFileToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.fileToSignPath = path;
    }

    public void setFileToSign(String path) throws IOException {
        this.setFileToSign(Paths.get(path, new String[0]));
    }

    public void setDataFile(InputStream inputStream) throws IOException {
        int nRead;
        byte[] buff = new byte[1024];
        Path tempPath = this.createTempFile();
        FileOutputStream outputStream = new FileOutputStream(tempPath.toFile());
        while ((nRead = inputStream.read(buff, 0, buff.length)) != -1) {
            ((OutputStream)outputStream).write(buff, 0, nRead);
        }
        ((OutputStream)outputStream).close();
        this.dataFilePath = tempPath;
    }

    public void setDataFile(byte[] content) throws IOException {
        this.setDataFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setDataFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided data file was not found");
        }
        this.dataFilePath = path;
    }

    public void setDataFile(String path) throws IOException {
        this.setDataFile(Paths.get(path, new String[0]));
    }

    @Deprecated
    public void setTransferFilePath(Path path) {
        this.setTransferFileId(path.toString());
    }

    @Deprecated
    public void setTransferFilePath(String path) {
        this.setTransferFileId(path);
    }

    public void setTransferFileId(String transferFileId) {
        if (!Files.exists(this.config.getTransferDataFolder().resolve(transferFileId), new LinkOption[0])) {
            throw new RuntimeException("The provided transfer file was not found");
        }
        this.transferFileId = transferFileId;
    }

    public void setSignature(String signature) {
        try {
            Util.decodeBase64(signature);
        }
        catch (Exception ex) {
            throw new RuntimeException("The provided signature was not valid");
        }
        this.signature = signature;
    }

    public void setOutputFilePath(Path path) {
        this.outputFilePath = path;
    }

    public void setOutputFilePath(String path) {
        this.setOutputFilePath(Paths.get(path, new String[0]));
    }

    public PKCertificate complete() throws IOException {
        return this.complete(false);
    }

    public PKCertificate complete(boolean getCert) throws IOException {
        if (this.fileToSignPath == null) {
            throw new RuntimeException("The file to be signed was not set");
        }
        if (this.transferFileId == null) {
            throw new RuntimeException("The transfer data file was not set");
        }
        if (this.signature == null) {
            throw new RuntimeException("The signature was not set");
        }
        if (this.outputFilePath == null) {
            throw new RuntimeException("The output destination was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.fileToSignPath.toString());
        args.add(this.config.getTransferDataFolder().resolve(this.transferFileId).toString());
        args.add(this.signature);
        args.add(this.outputFilePath.toString());
        if (this.dataFilePath != null) {
            args.add("--data-file");
            args.add(this.dataFilePath.toString());
        }
        if (getCert) {
            this.versionManager.requireVersion(new Version("1.8"));
            OperatorResult result = this.invoke(CommandEnum.CommandCompleteSig, args);
            SignatureResult resultModel = this.parseOutput(result.getOutput()[0], SignatureResult.class);
            return new PKCertificate(resultModel.getSigner());
        }
        this.invokePlain(CommandEnum.CommandCompleteSig, args);
        return null;
    }
}

