/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class SignatureExplorer
extends PkiExpressOperator {
    protected Path signatureFilePath;
    private boolean validate;
    private boolean fillCertContent;
    private boolean trustUncertifiedSigningTime;

    public SignatureExplorer(PkiExpressConfig config) {
        super(config);
    }

    protected void verifyAndAddCommonOptions(List<String> args) {
        if (this.validate) {
            args.add("--validate");
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.trustUncertifiedSigningTime) {
            args.add("--trust-uncertified-signing-time");
            this.versionManager.requireVersion(new Version("1.23"));
        }
        if (this.fillCertContent) {
            args.add("--fill-cert-content");
            this.versionManager.requireVersion(new Version("1.23"));
        }
    }

    public void setSignatureFile(InputStream inputStream) throws IOException {
        this.signatureFilePath = this.writeToTempFile(inputStream);
    }

    public void setSignatureFile(byte[] content) throws IOException {
        this.setSignatureFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setSignatureFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.signatureFilePath = path;
    }

    public void setSignatureFile(String path) throws IOException {
        this.setSignatureFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setTrustUncertifiedSigningTime(boolean trust) {
        this.trustUncertifiedSigningTime = trust;
    }

    public void setFillCertContent(boolean fillCertContent) {
        this.fillCertContent = fillCertContent;
    }

    public boolean getTrustUncertifiedSigningTime() {
        return this.trustUncertifiedSigningTime;
    }

    public boolean getFillCertContent() {
        return this.fillCertContent;
    }
}

