/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.InstallationNotFoundException;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.StandardSignaturePolicies;
import com.lacunasoftware.pkiexpress.TimestampAuthority;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import com.lacunasoftware.pkiexpress.VersionManager;
import com.lacunasoftware.pkiexpress.XmlSignaturePolicies;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PkiExpressOperator {
    private List<Path> tempFiles;
    private Map<String, Path> fileReferences;
    private Boolean disposed = false;
    protected PkiExpressConfig config;
    protected List<Path> trustedRoots;
    protected boolean trustOnlyICPBrasil = false;
    protected boolean trustOnlySystem = false;
    protected Boolean offline = false;
    protected VersionManager versionManager;
    protected StandardSignaturePolicies signaturePolicy;
    protected TimestampAuthority timestampAuthority;
    protected String culture;
    protected String timeZone;
    @Deprecated
    public Boolean trustLacunaTestRoot = false;
    private static SecureRandom rng = new SecureRandom();

    protected PkiExpressOperator(PkiExpressConfig config) {
        this.config = config;
        this.trustedRoots = new ArrayList<Path>();
        this.tempFiles = new ArrayList<Path>();
        this.fileReferences = new HashMap<String, Path>();
        this.versionManager = new VersionManager();
    }

    protected PkiExpressOperator() throws IOException {
        this(new PkiExpressConfig());
    }

    private String escapeArgument(String arg) {
        String content;
        int firstQuote = arg.indexOf(34);
        int lastQuote = arg.lastIndexOf(34);
        boolean hasQuotes = false;
        if (firstQuote == 0 && lastQuote == arg.length() - 1) {
            content = arg.substring(1, arg.length() - 2);
            hasQuotes = true;
        } else {
            content = arg;
        }
        String escaped = content.replace("\"", "\\\"");
        if (hasQuotes) {
            return String.format("\"%s\"", escaped);
        }
        return escaped;
    }

    protected String[] invokePlain(CommandEnum command, List<String> args) throws IOException {
        OperatorResult result = this.invoke(command, args, true);
        return result.getOutput();
    }

    protected OperatorResult invoke(CommandEnum command, List<String> args) throws IOException {
        return this.invoke(command, args, false);
    }

    protected OperatorResult invoke(CommandEnum command, List<String> args, boolean plainOutput) throws IOException {
        int output;
        String lineBuff;
        Process proc;
        ArrayList<String> cmdArgs = new ArrayList<String>(this.getPkiExpressInvocation());
        cmdArgs.add(command.getValue());
        cmdArgs.addAll(args);
        if (this.fileReferences != null && !this.fileReferences.isEmpty()) {
            for (String key : this.fileReferences.keySet()) {
                cmdArgs.add("--file-reference");
                cmdArgs.add(String.format("%s=%s", key, this.fileReferences.get(key)));
            }
        }
        if (this.trustedRoots != null && !this.trustedRoots.isEmpty()) {
            for (Path trustedRoot : this.trustedRoots) {
                cmdArgs.add("--trust-root");
                cmdArgs.add(trustedRoot.toString());
            }
        }
        if (this.trustOnlyICPBrasil) {
            cmdArgs.add("--trust-clear");
            cmdArgs.add("--trust-brazil");
        }
        if (this.trustOnlySystem) {
            cmdArgs.add("--trust-clear");
            cmdArgs.add("--trust-system");
        }
        if (this.trustLacunaTestRoot.booleanValue()) {
            cmdArgs.add("--trust-test");
        }
        if (this.offline.booleanValue()) {
            cmdArgs.add("--offline");
            this.versionManager.requireVersion(new Version("1.2"));
        }
        if (!plainOutput) {
            cmdArgs.add("--base64");
            this.versionManager.requireVersion(new Version("1.3"));
        }
        if (this.culture != null) {
            cmdArgs.add("--culture");
            cmdArgs.add(this.culture);
            this.versionManager.requireVersion(new Version("1.10"));
        }
        if (this.timeZone != null) {
            cmdArgs.add("--timezone");
            cmdArgs.add(this.timeZone);
            this.versionManager.requireVersion(new Version("1.10"));
        }
        if (this.versionManager.requireMinVersionFlag()) {
            cmdArgs.add("--min-version");
            cmdArgs.add(this.versionManager.getMinVersion().toString());
        }
        String[] argArr = new String[cmdArgs.size()];
        cmdArgs.toArray(argArr);
        for (int i = 0; i < argArr.length; ++i) {
            argArr[i] = this.escapeArgument(argArr[i]);
        }
        try {
            proc = Runtime.getRuntime().exec(argArr);
        }
        catch (IOException ex) {
            throw new InstallationNotFoundException("Could not find PKI Express' installation.", ex);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        ArrayList<String> response = new ArrayList<String>();
        while ((lineBuff = input.readLine()) != null) {
            response.add(lineBuff);
        }
        try {
            output = proc.waitFor();
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.getOutputStream().close();
            proc.destroy();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("An unexpected InterruptedException has occurred", ex);
        }
        String[] responseArr = new String[response.size()];
        response.toArray(responseArr);
        OperatorResult result = new OperatorResult(output, responseArr);
        if (result.getResponse() != 0) {
            StringBuilder sb = new StringBuilder();
            for (String line : result.getOutput()) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            if (result.getResponse() == 1 && this.versionManager.getMinVersion().compareTo(new Version("1.0")) > 0) {
                String errorMsg = String.format("%s %s>>>>> TIP: This operation requires PKI Express %s, please check your PKI Express version.", sb.toString(), System.getProperty("line.separator"), this.versionManager.getMinVersion());
                throw new RuntimeException(errorMsg);
            }
            throw new RuntimeException(sb.toString());
        }
        return result;
    }

    protected List<String> getPkiExpressInvocation() throws InstallationNotFoundException {
        String os;
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            os = "linux";
        } else if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            os = "win";
        } else {
            throw new RuntimeException("Unsupported OS: " + System.getProperty("os.name").toLowerCase());
        }
        Path home = this.config.getPkiExpressHome();
        if (home != null) {
            if (os.equals("linux")) {
                if (!Files.exists(home.resolve("pkie.dll"), new LinkOption[0])) {
                    throw new InstallationNotFoundException("The file pkie.dll could not be found on directory " + home.toString());
                }
            } else if (!Files.exists(home.resolve("pkie.exe"), new LinkOption[0])) {
                throw new InstallationNotFoundException("The file pkie.exe could not be found on directory " + home.toString());
            }
        } else if (os.equals("win")) {
            if (Files.exists(Paths.get(System.getenv("ProgramFiles"), new String[0]).resolve("Lacuna Software\\PKI Express\\pkie.exe"), new LinkOption[0])) {
                home = Paths.get(System.getenv("ProgramFiles"), new String[0]).resolve("Lacuna Software\\PKI Express");
            } else if (Files.exists(Paths.get(System.getenv("ProgramFiles(x86)"), new String[0]).resolve("Lacuna Software\\PKI Express\\pkie.exe"), new LinkOption[0])) {
                home = Paths.get(System.getenv("ProgramFiles(x86)"), new String[0]).resolve("Lacuna Software\\PKI Express");
            } else if (Files.exists(Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Lacuna Software\\PKI Express\\pkie.exe"), new LinkOption[0])) {
                home = Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Lacuna Software\\PKI Express");
            } else if (Files.exists(Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Lacuna Software\\PKI Express (x86)\\pkie.exe"), new LinkOption[0])) {
                home = Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Lacuna Software\\PKI Express (x86)");
            }
            if (home == null) {
                throw new InstallationNotFoundException("Could not determine the installation folder of PKI Express. If you installed PKI Express on a custom folder, make sure you are specifying it on the PkiExpressConfig object.");
            }
        }
        ArrayList<String> invocArgs = new ArrayList<String>();
        if (os.equals("linux")) {
            if (home != null) {
                invocArgs.add("dotnet");
                invocArgs.add(home.resolve("pkie.dll").toString());
            } else {
                invocArgs.add("pkie");
            }
        } else {
            invocArgs.add(home.resolve("pkie.exe").toString());
        }
        return invocArgs;
    }

    protected Path createTempFile() throws IOException {
        Path tempFile = Files.createTempFile(this.config.getTempFolder(), "pkie", "", new FileAttribute[0]);
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    protected String getTransferFileName() {
        byte[] bytes = new byte[16];
        rng.nextBytes(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    protected Path writeToTempFile(InputStream inputStream) throws IOException {
        int nRead;
        byte[] buff = new byte[1024];
        Path tempPath = this.createTempFile();
        FileOutputStream outputStream = new FileOutputStream(tempPath.toFile());
        while ((nRead = inputStream.read(buff, 0, buff.length)) != -1) {
            ((OutputStream)outputStream).write(buff, 0, nRead);
        }
        ((OutputStream)outputStream).close();
        return tempPath;
    }

    protected <TResponse> TResponse parseOutput(String outputBase64, Class<TResponse> responseType) throws IOException {
        byte[] output = Util.decodeBase64(outputBase64);
        return (TResponse)new ObjectMapper().readValue(output, responseType);
    }

    public Boolean getTrustLacunaTestRoot() {
        return this.trustLacunaTestRoot;
    }

    public void setTrustLacunaTestRoot(Boolean trustLacunaTestRoot) {
        this.trustLacunaTestRoot = trustLacunaTestRoot;
    }

    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (!this.disposed.booleanValue()) {
            for (Path tempFile : this.tempFiles) {
                try {
                    Files.delete(tempFile);
                }
                catch (Exception exception) {}
            }
            this.disposed = true;
        }
    }

    public void addFileReference(String alias, Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("The provided file path was not found");
        }
        this.fileReferences.put(alias, path);
    }

    public void addFileReference(String alias, String path) {
        this.addFileReference(alias, path != null ? Paths.get(path, new String[0]) : null);
    }

    public void addTrustedRoot(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("The provided trusted root was not found");
        }
        this.trustedRoots.add(path);
    }

    public void addTrustedRoot(String path) {
        this.addTrustedRoot(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setTrustOnlyICPBrasil(boolean trust) {
        this.trustOnlyICPBrasil = trust;
    }

    public void setTrustOnlySystem(boolean trust) {
        this.trustOnlySystem = trust;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public void setSignaturePolicy(StandardSignaturePolicies signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    @Deprecated
    public void setSignaturePolicy(XmlSignaturePolicies signaturePolicy) {
        switch (signaturePolicy) {
            case NFe: {
                this.signaturePolicy = StandardSignaturePolicies.NFePadraoNacional;
                break;
            }
            case Basic: {
                this.signaturePolicy = StandardSignaturePolicies.XmlDSigBasic;
                break;
            }
            default: {
                throw new RuntimeException("Invalid signature policy: " + signaturePolicy.getValue());
            }
        }
    }

    public void setTimestampAuthority(TimestampAuthority timestampAuthority) {
        this.timestampAuthority = timestampAuthority;
    }
}

