/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PkiExpressConfig {
    private Path pkiExpressHome;
    private Path tempFolder;
    private Path transferDataFolder;

    public PkiExpressConfig() throws IOException {
        this((Path)null);
    }

    public PkiExpressConfig(Path pkiExpressHome) throws IOException {
        this(pkiExpressHome, null);
    }

    public PkiExpressConfig(String pkiExpressHome) throws IOException {
        this(pkiExpressHome != null ? Paths.get(pkiExpressHome, new String[0]) : null);
    }

    public PkiExpressConfig(Path pkiExpressHome, Path tempFolder) throws IOException {
        this(pkiExpressHome, tempFolder, null);
    }

    public PkiExpressConfig(String pkiExpressHome, String tempFolder) throws IOException {
        this(pkiExpressHome != null ? Paths.get(pkiExpressHome, new String[0]) : null, tempFolder != null ? Paths.get(tempFolder, new String[0]) : null);
    }

    public PkiExpressConfig(Path pkiExpressHome, Path tempFolder, Path transferFilesFolder) throws IOException {
        if (pkiExpressHome != null && pkiExpressHome.toString().endsWith(".config")) {
            throw new RuntimeException("Starting on version 1.1.0 of PKI Express, passing a licensing on the PKIExpressConfig constructor is not longer supported!");
        }
        this.tempFolder = tempFolder != null && Files.exists(tempFolder, new LinkOption[0]) ? tempFolder : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        this.transferDataFolder = transferFilesFolder != null && Files.exists(transferFilesFolder, new LinkOption[0]) ? transferFilesFolder : this.tempFolder;
        this.pkiExpressHome = pkiExpressHome;
    }

    public PkiExpressConfig(String pkiExpressHome, String tempFolder, String transferFilesFolder) throws IOException {
        this(pkiExpressHome != null ? Paths.get(pkiExpressHome, new String[0]) : null, tempFolder != null ? Paths.get(tempFolder, new String[0]) : null, transferFilesFolder != null ? Paths.get(transferFilesFolder, new String[0]) : null);
    }

    public Path getPkiExpressHome() {
        return this.pkiExpressHome;
    }

    public Path getTempFolder() {
        return this.tempFolder;
    }

    public Path getTransferDataFolder() {
        return this.transferDataFolder;
    }
}

