/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.Pkcs12GenerationResult;
import com.lacunasoftware.pkiexpress.Pkcs12GenerationResultModel;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class Pkcs12Generator
extends PkiExpressOperator {
    private String key;
    private Path certFilePath;
    private String password;

    public Pkcs12Generator(PkiExpressConfig config) {
        super(config);
    }

    public Pkcs12Generator() throws IOException {
        this(new PkiExpressConfig());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Path getCertFilePath() {
        return this.certFilePath;
    }

    public void setCertFile(InputStream inputStream) throws IOException {
        this.certFilePath = this.writeToTempFile(inputStream);
    }

    public void setCertFile(byte[] content) throws IOException {
        this.setCertFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setCertFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.certFilePath = path;
    }

    public void setCertFile(String path) throws IOException {
        this.setCertFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Pkcs12GenerationResult generate() throws IOException {
        String password = this.password;
        return this.generate(password);
    }

    public Pkcs12GenerationResult generate(String password) throws IOException {
        if (this.key == null) {
            throw new RuntimeException("The generated key was not set");
        }
        if (this.certFilePath == null) {
            throw new RuntimeException("The certificate file was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.key);
        args.add(this.certFilePath.toString());
        if (password != null) {
            args.add("--password");
            args.add(password);
        }
        this.versionManager.requireVersion(new Version("1.11"));
        OperatorResult result = this.invoke(CommandEnum.CommandCreatePfx, args);
        Pkcs12GenerationResultModel resultModel = this.parseOutput(result.getOutput()[0], Pkcs12GenerationResultModel.class);
        return new Pkcs12GenerationResult(resultModel);
    }
}

